#include "stdafx.hpp"

#include <assert.h>

#include "..\FWatch\FileTimeComparator.hpp"

void testFileTimeComparator()
{
	SYSTEMTIME systime = { 0 };
	systime.wYear = 2005;
	systime.wMonth = 5;
	systime.wDay = 1;
	systime.wDayOfWeek = 0;
	systime.wHour = 10;
	systime.wMinute = 11;
	systime.wSecond = 12;
	systime.wMilliseconds = 345;

	CFileTime a;
	::SystemTimeToFileTime( &systime, &a );
	
	CFileTime b1;
	systime.wSecond = 13;
	::SystemTimeToFileTime( &systime, &b1 );

	CFileTime b2;
	systime.wSecond = 11;
	::SystemTimeToFileTime( &systime, &b2 );

	CFileTime c1;
	systime.wSecond = 14;
	::SystemTimeToFileTime( &systime, &c1 );

	CFileTime c2;
	systime.wSecond = 10;
	::SystemTimeToFileTime( &systime, &c2 );

	const FileTimeComparator comp( CFileTimeSpan( 1000 * 10000 ) ); // b͈͓̔͂Ƃ݂ȂB

	assert( comp( a, b1 ) );
	assert( comp( b1, a ) );
	assert( comp( a, b2 ) );
	assert( comp( b2, a ) );

	assert( ! comp( a, c1 ) );
	assert( ! comp( c1, a ) );
	assert( ! comp( a, c2 ) );
	assert( ! comp( c2, a ) );
}
