#ifndef INCLUDE_H_FWATCHSETTINGDLG
#define INCLUDE_H_FWATCHSETTINGDLG

#include "DialogLayoutExpander.hpp"
#include "WatchTaskGroup.hpp"

class FWatchSettingDlg {
private:
	FWatchSettingDlg( const FWatchSettingDlg& ); //<! Ȃ
	operator=( const FWatchSettingDlg& ); //<! Ȃ

public:
	FWatchSettingDlg( WatchTaskGroup& v_watchTaskGroup );
	~FWatchSettingDlg();
	void show( HWND hWnd );

private:
	WatchTaskGroup& watchTaskGroup_;

	HWND hDlg_;
	HWND hList_;
	HWND hStatus_;

	DialogLayoutExpander layout_;

private:
	int GetColumnCount() const;
	tstring GetColText( unsigned int idx, unsigned int col) const;
	tstring GetColTitle(int col) const;

	void onInitDialog();
	BOOL onCommand( UINT btn );
	BOOL onNotify( WPARAM wParam, LPARAM lParam );
	void onEdit( bool bEditMode );
	void onDelete();
	void onSaveAsConfig();
	void onSizing( WPARAM wParam, LPARAM lParam );
	void onSize( WPARAM wParam, LPARAM lParam );

	void displayStatus() const;

	static INT_PTR CALLBACK DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );
};

#endif
