#ifndef INCLUDE_H_EVENTDISPATCHER
#define INCLUDE_H_EVENTDISPATCHER

#include "EventListener.hpp"

#include <map>

class EventDispatcher : public virtual EventListener
{
public:
	EventDispatcher();
	virtual ~EventDispatcher() throw();

	virtual void sweepEvent() throw();
	virtual bool isEventListenerAvailable() const throw();

	virtual void notifyFileEvent( DWORD v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw();
	virtual void notifyEvent( DWORD v_eventId ) throw();

	virtual void appendEventListener( EventListener* v_pEventListener, bool v_autoRemove = false ) throw();
	virtual void removeEventListener( EventListener* v_pEventListener ) throw();

private:
	typedef std::map< EventListener*, bool > EventListenerMap;
	EventListenerMap eventListeners_;
};

#endif
