#include "stdafx.hpp"

#include "ActionListener.hpp"

ActionListener::ActionListener( const ActionSettingInfo& v_actionSettingInfo )
	: maxProcess_( v_actionSettingInfo.getMaxProcess() )
	, processCount_( 0 )
{
	ActionInvokerFactory actionInvokerFactory;
	pActionInvoker_ = actionInvokerFactory.create( v_actionSettingInfo );
}

ActionListener::~ActionListener() throw()
{
}

void ActionListener::sweepEvent() throw()
{
	if( pActionInvoker_.get() ) {
		processCount_ = pActionInvoker_->sweepTerminatedProcess();
	}
	else {
		processCount_ = 0;
	}
}

bool ActionListener::isEventListenerAvailable() const throw()
{
	bool result = false;
	if( pActionInvoker_.get() ) {
		result = ( maxProcess_ == 0 ) || ( maxProcess_ > processCount_ );
	}
	return result;
}

void ActionListener::notifyFileEvent( DWORD v_eventId, const tstring& v_absolutePath, const FileInfo& v_fileInfo ) throw()
{
	if( v_eventId == 0 ) { //TODO:MSGID
		if( pActionInvoker_.get() ) {
			if( pActionInvoker_->createProcess( v_absolutePath, v_fileInfo ) ) {
				processCount_ = pActionInvoker_->sweepTerminatedProcess();
			}
		}
	}
}

void ActionListener::notifyEvent( DWORD v_eventId ) throw()
{
}

