#ifndef INCLUDE_H_TSTRINGUTY
#define INCLUDE_H_TSTRINGUTY

#include "tstring.hpp"

#include <iterator>
#include <ostream>

class tstringuty {
private:
	tstringuty(); //<! Ȃ
public:

	/*!
	* 𕶎ƂĕԂ܂B
	* ԂIuWFNg͈ꎞIuWFNgłB
	* \param v_value 
	* \return 
	*/
	static tstring IntToString( int v_value ) throw();

	/*!
	* 𕶎ɕϊĕԂ܂B
	* ԂIuWFNg͈ꎞIuWFNgłB
	* \param v_format tH[}bg
	* \return 
	*/
	static tstring ToString( const LPCTSTR v_format, ... ) throw();

	/*!
	* ̑OɊ܂܂󔒂ƃ^v菜Ԃ܂B
	* ͔j󂳂܂B
	* Ԃ镶͈ꎞIIuWFNgłB
	*/
	static tstring trimSpaceBoth( const tstring& v_in );

	/*!
	* 񂪎w肵ŏI[邱ƂۏႵ܂B
	* ͔j󂳂܂B
	* Ԃ镶͈ꎞIuWFNgłB
	* \param v_str 
	* \param v_endStr I[镶
	* \return I[Ă邱ƂۏႳꂽ(ꎞIuWFNg)
	*/
	static tstring ensureEndsWith( const tstring& v_str, const tstring& v_endStr ) throw();

	/*!
	* JEg܂B
	* _uoCg̏ꍇ2oCg1JEg܂B
	* \return 
	*/
	static tstring::size_type getCharCount( const tstring& v_str ) throw();

	/*!
	 * w肵̃CfbNXԂ܂B
	 * _uoCg̏ꍇ2oCg1JEg܂B
	 * ۂ̒̕傫ꍇ͏I[+1()Ԃ܂B
	 * \param v_str 
	 * \param v_index 
	 * \return CfbNX
	 */
	static tstring::size_type getCharIndex( const tstring& v_str, tstring::size_type v_index ) throw();

	/*!
	 * ̌琔Ďw肵̃CfbNXԂ܂B
	 * _uoCg̏ꍇ2oCg1JEg܂B
	 * ۂ̒̕傫ꍇ0Ԃ܂B
	 * \param v_str 
	 * \param v_lastIndex 
	 * \return CfbNX
	 */
	static tstring::size_type getCharLastIndex( const tstring& v_str, tstring::size_type v_lastIndex ) throw();

	static bool isMatch( const tstring& v_text, const tstring& v_pattern ) throw();

	/*!
	* 񂩂琮(int)擾܂B
	* s󔒂͖܂B
	* \param v_text 
	* \return 
	*/
	static int atoi( const tstring& v_text ) throw();

	/*!
	* 񂩂琮(long)擾܂B
	* s󔒂͖܂B
	* \param v_text 
	* \return 
	*/
	static int atol( const tstring& v_text ) throw();

	/*!
	* 񂩂琮(long long)擾܂B
	* s󔒂͖܂B
	* \param v_text 
	* \return 
	*/
	static __int64 atoi64( const tstring& v_text ) throw();

	/*!
	 * UNICODEԂ܂B
	 * \param 
	 * \return UNICODE
	 */
	static std::string getStdString( const tstring& v_text ) throw();

	/*!
	 * UNICODEԂ܂B
	 * \param 
	 * \return UNICODE
	 */
	static std::wstring getWStdString( const tstring& v_text ) throw();

	/*!
	 * UNICODE݂tstrinǧ^ɕϊĕԂ܂B
	 * \param 
	 * \return ݂̕TCY̕
	 */
	static tstring getTString( const std::string& v_text ) throw();

	/*!
	 * UNICODE݂tstrinǧ^ɕϊĕԂ܂B
	 * \param 
	 * \return ݂̕TCY̕
	 */
	static tstring getTString( const std::wstring& v_text ) throw();

};

/*!
 * w肵؂蕶ŋ؂ꂽ}Ce[^ŎReiɑ}܂B
 * \param v_line 
 * \param v_chr ؂蕶
 * \param v_ite }Ce[^
 */
template<class Cont> void split( const tstring& v_line, TCHAR v_chr, std::back_insert_iterator<Cont> v_ite ) throw()
{
	const tstring::size_type len = v_line.length();
	tstring::size_type idx = 0;
	tstring::size_type lastIdx = 0;
	for(;;) {
		const tstring::value_type ch = ( idx < len ) ? v_line[ idx ] : 0;
		if( ch == v_chr || ch == 0 ) {
			const tstring token = v_line.substr( lastIdx, idx - lastIdx );
			*v_ite++ = token;
			lastIdx = idx + 1;
		}
		if( idx >= len ) {
			break;
		}
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( ch ) ) {
			idx++;
		}
#endif
		idx++;
	}
}

std::string convertWStringToString( const std::wstring& v_text ) throw();

std::wstring convertStringToWString( const std::string& v_text ) throw();

/*!
 * 󔒂ŋ؂ꂽ}Ce[^ŎReiɑ}܂B
 * 񂪃_uNH[e[Vň͂܂Ă͈͂ł͋󔒂͖܂B
 * \param v_line 
 * \param v_ite }Ce[^
 */
template<class Cont> void splitArgs( const tstring& v_line, std::back_insert_iterator<Cont> v_ite ) throw()
{
	tstring tmp;

	enum {
		INITIAL = 0,
		NORMAL  = 1,
		ESCAPE  = 2,
		ESCAPE_CANCEL = 3
	} mode = INITIAL;

	const tstring::size_type len = v_line.length();
	tstring::size_type idx = 0;
	for(;;) {
		const tstring::value_type ch = ( idx < len ) ? v_line[ idx ] : 0;

		if( mode == INITIAL ) {
			if( ch >= 0 && ch <= ' ' ) {
				// do nothing.
			}
			else if( ch == '\"' ) {
				mode = ESCAPE;
			}
			else if( ch != 0 ) {
				tmp += ch;
				mode = NORMAL;
			}
		}
		else if( mode == NORMAL ) {
			if( ch == ' ' || ch == 0 ) {
				*v_ite++ = tmp;
				tmp.clear();
				mode = INITIAL;
			}
			else if( ch == '\"' ) {
				mode = ESCAPE;
			}
			else {
				tmp += ch;
			}
		}
		else if( mode == ESCAPE ) {
			if( ch == 0 ) {
				mode = NORMAL;
				continue;
			}
			else if( ch == '\"' ) {
				mode = ESCAPE_CANCEL;
			}
			else {
				tmp += ch;
			}
		}
		else if( mode == ESCAPE_CANCEL ) {
			if( ch == '\"' ) {
				tmp += ch;
				mode = ESCAPE;
			}
			else {
				mode = NORMAL;
				continue;
			}
		}

		if( idx >= len ) {
			break;
		}
#ifndef _UNICODE
		if( ::IsDBCSLeadByte( ch ) ) {
			idx++;
		}
#endif
		idx++;
	}
}

#endif
