#ifndef INCLUDE_H_XMLWRITER
#define INCLUDE_H_XMLWRITER

#include "SAXContentHandler.hpp"

#include <memory>

class SAXAttributesHolder : public SAXAttributes
{
public:
	virtual ~SAXAttributesHolder() {}

	virtual void clear() = 0;

	virtual void addAttribute(
		const tstring& v_ns,
		const tstring& v_localName,
		const tstring& v_qName,
		const tstring& v_type,
		const tstring& v_value ) = 0;

	virtual void removeAttribute( int v_index ) = 0;

	virtual void setAttribute(
		int v_index,
		const tstring& v_ns,
		const tstring& v_localName,
		const tstring& v_qName,
		const tstring& v_type,
		const tstring& v_value ) = 0;
};

typedef std::auto_ptr<SAXAttributesHolder> SAXAttributesHolderPtr;

class XMLWriter : public SAXContentHandler
{
public:

	virtual ~XMLWriter() throw() {};

	virtual SAXAttributesHolderPtr createAttributesHolder() = 0;
};

typedef std::auto_ptr<XMLWriter> XMLWriterPtr;

class XMLWriterFactory
{
private:
	XMLWriterFactory( const XMLWriterFactory& ); //<! Ȃ
	operator=( const XMLWriterFactory& ); //<! Ȃ

public:
	XMLWriterFactory();
	~XMLWriterFactory();

	XMLWriterPtr create( const tstring& v_fileName );

};

#endif
