#ifndef INCLUDE_H_TASK
#define INCLUDE_H_TASK

#include "Thread.hpp"

#include <vector>

class Task
{
public:
	virtual ~Task() throw() {};
	virtual void onThreadBinded() = 0;
	virtual void onThreadSignal() = 0;
	virtual void onThreadTick() = 0;
	virtual void onThreadUnbinded() = 0;
	virtual HANDLE getWaitableHandle() = 0;
};

class MultiTask
{
public:

	virtual ~MultiTask() {}

	/*!
	 * XPW[Jn܂B
	 */
	virtual void startSchedule() = 0;

	/*!
	 * XPW[Ă邩擾܂B
	 * \return XPW[ĂtrueAłȂfalse
	 */
	virtual bool isScheduling() const = 0;

	/*!
	 * XPW[~܂B
	 * XPW[͓o^ꂽ܂܂łĊJ\łB
	 */
	virtual void stopSchedule() = 0;

	/*!
	 * XPW[Zbg܂B
	 * ׂẴXPW[̓o^폜܂B
	 */
	virtual void resetSchedule() = 0;

	/*!
	 * o^Ă^XNԂ܂B
	 * \return o^Ă^XN
	 */
	virtual size_t size() const = 0;

	/*!
	 * ^XNǉ܂B
	 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
	 * ^XN̏𒴂Ȃǂɂ^XNo^łȂꍇfalseԂ܂B
	 * \param v_task ^XN
	 * \param v_autoRelease 폜ꍇ
	 * \return o^ꂽꍇAtrue
	 */
	virtual bool appendTask( Task* v_pTask, bool v_autoRelease ) = 0;

	/*!
	 * ^XN폜܂B
	 * łɃ^XNJnĂꍇ́AICxg܂B
	 * ݂Ȃ^XNw肵ꍇ͉܂B
	 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
	 * \param v_task ^XN
	 * \return 폜ꂽꍇtrueAΏۂȂꍇfalse
	 */
	virtual bool removeTask( Task* v_pTask ) = 0;

};

class BasicMultiTask : public MultiTask, protected BasicThread
{
public:
	BasicMultiTask( DWORD v_waitTime );

	virtual ~BasicMultiTask();

	/*!
	 * XPW[Jn܂B
	 */
	virtual void startSchedule();

	/*!
	 * XPW[Ă邩擾܂B
	 * \return XPW[ĂtrueAłȂfalse
	 */
	virtual bool isScheduling() const;

	/*!
	 * XPW[~܂B
	 * XPW[͓o^ꂽ܂܂łĊJ\łB
	 */
	virtual void stopSchedule();

	/*!
	 * XPW[Zbg܂B
	 * ׂẴXPW[̓o^폜܂B
	 */
	virtual void resetSchedule();

	/*!
	 * o^łő^XNԂ܂B
	 * \return o^ł^XN
	 */
	virtual inline size_t getMaxTask() const
	{
		return MAX_TASK;
	}

	/*!
	 * o^Ă^XNԂ܂B
	 * \return o^Ă^XN
	 */
	virtual size_t size() const;

	/*!
	 * ^XNǉ܂B
	 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
	 * ^XN̏𒴂Ȃǂɂ^XNo^łȂꍇfalseԂ܂B
	 * \param v_task ^XN
	 * \param v_autoRelease 폜ꍇ
	 * \return o^ꂽꍇAtrue
	 */
	virtual bool appendTask( Task* v_pTask, bool v_autoRelease );

	/*!
	 * ^XN폜܂B
	 * łɃ^XNJnĂꍇ́AICxg܂B
	 * ݂Ȃ^XNw肵ꍇ͉܂B
	 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
	 * \param v_task ^XN
	 * \return 폜ꂽꍇtrueAΏۂȂꍇfalse
	 */
	virtual bool removeTask( Task* v_pTask );

protected:
	/*!
	 * s
	 */
	virtual void run();

private:

	/*!
	 * ҋ@𑦎ɉ܂B
	 */
	void interrupt() const;

private:

	struct TaskState {
		Task* task_;
		bool bInit_;
		bool bExit_;
		bool bAutoRelease_;
	};

	mutable CriticalSection lock_;
	HANDLE hInterrupted_;
	DWORD waitTime_;

	typedef std::vector<TaskState> TaskStateList;

	TaskStateList taskStateList_;

	static const int MAX_TASK = 60;
};


class BasicMultiTaskEx : public MultiTask
{
public:
	BasicMultiTaskEx( int v_waitTime );
	virtual ~BasicMultiTaskEx();

	/*!
	 * XPW[Jn܂B
	 */
	virtual void startSchedule();

	/*!
	 * XPW[Ă邩擾܂B
	 * \return XPW[ĂtrueAłȂfalse
	 */
	virtual bool isScheduling() const;

	/*!
	 * XPW[~܂B
	 * XPW[͓o^ꂽ܂܂łĊJ\łB
	 */
	virtual void stopSchedule();

	/*!
	 * XPW[Zbg܂B
	 * ׂẴXPW[̓o^폜܂B
	 */
	virtual void resetSchedule();

	/*!
	 * o^Ă^XNԂ܂B
	 * \return o^Ă^XN
	 */
	virtual size_t size() const;

	/*!
	 * ^XNǉ܂B
	 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
	 * ^XN̏𒴂Ȃǂɂ^XNo^łȂꍇfalseԂ܂B
	 * \param v_task ^XN
	 * \param v_autoRelease 폜ꍇ
	 * \return o^ꂽꍇAtrue
	 */
	virtual bool appendTask( Task* v_pTask, bool v_autoRelease );

	/*!
	 * ^XN폜܂B
	 * łɃ^XNJnĂꍇ́AICxg܂B
	 * ݂Ȃ^XNw肵ꍇ͉܂B
	 * ^XÑR[obNɁÃ\bhĂяoĂ͂Ȃ܂B
	 * \param v_task ^XN
	 * \return 폜ꂽꍇtrueAΏۂȂꍇfalse
	 */
	virtual bool removeTask( Task* v_pTask );

private:
	typedef std::vector<BasicMultiTask*> BasicMultiTaskList;
	BasicMultiTaskList multiTaskList_;

	const int waitTime_;
};


#endif
