#ifndef INCLUDE_H_SAXCONTEXTHANDLER
#define INCLUDE_H_SAXCONTEXTHANDLER

#include "tstring.hpp"

#include <map>

class SAXAttributes
{
public:
	virtual ~SAXAttributes() {}

	virtual int getLength() const = 0;
	virtual tstring getURI(int) const = 0;
	virtual tstring getLocalName(int) const = 0;
	virtual tstring getQName(int) const = 0;
	virtual void getName(int, tstring*, tstring*, tstring* ) const = 0;
	virtual int getIndexFromName( const tstring&, const tstring& ) const = 0;
	virtual int getIndexFromQName( const tstring& ) const = 0;
	virtual tstring getType(int) const = 0;
	virtual tstring getTypeFromName( const tstring&, const tstring& ) const = 0;
	virtual tstring getTypeFromQName( const tstring& ) const = 0;
	virtual tstring getValue(int) const = 0;
	virtual tstring getValueFromName( const tstring&, const tstring& ) const = 0;
	virtual tstring getValueFromQName( const tstring& ) const = 0;
};

class SAXContentHandler
{
public:
	virtual ~SAXContentHandler() {}
	
	virtual void startDocument() = 0;

	virtual void endDocument() = 0;

	virtual void startPrefixMapping(const tstring&, const tstring& ) = 0;

	virtual void endPrefixMapping(const tstring& ) = 0;

	virtual void startElement(
		const tstring& v_namespace,
		const tstring& v_localName,
		const tstring& v_QName,
		const SAXAttributes& pAttr
		) = 0;

	virtual void endElement(
		const tstring& v_namespace,
		const tstring& v_localName,
		const tstring& v_QName
		) = 0;

	virtual void characters(const tstring& v_chars ) = 0;

	virtual void ignorableWhitespace(const tstring& v_chars ) = 0;

	virtual void processingInstruction( const tstring& , const tstring& ) = 0;

	virtual void skippedEntity( const tstring& ) = 0;

};

#endif
