#ifndef INCLUDE_H_FILEINFO
#define INCLUDE_H_FILEINFO

#include "tstring.hpp"

class FileInfo
{
public:
	FileInfo( const WIN32_FIND_DATA& v_finddata, bool v_modified, bool v_exists = true );
	
	FileInfo( const FileInfo& v_other );

	FileInfo& operator=( const FileInfo& v_other );

	~FileInfo();

	inline const FILETIME& getLastModified() const
	{
		return writetime_;
	}

	inline DWORD getSize() const
	{
		return size_;
	}

	inline bool isExist() const
	{
		return bExist_;
	}

	inline bool isDeletePending() const
	{
		return deletePending_;
	}

	inline DWORD getDeleteBeginTickCount() const
	{
		return deleteBeginTickCount_;
	}

	inline bool isDetectModified() const
	{
		return detectModified_;
	}

	inline DWORD getCountdownTickCount() const
	{
		return tickcount_;
	}

	void update( const WIN32_FIND_DATA& v_finddata );

	void setLastModified( const FILETIME& v_filetime );

	void setDeletePending( bool v_deletePending );

	void setDeleteBeginTickCount( DWORD v_tickcount );

	void setCountdownTickCount( DWORD v_tickcount );

	void setSize( DWORD v_size );

	void setExist( bool v_exist );

	void setDetectModified( bool v_detectModified );

private:
	FILETIME writetime_;
	DWORD size_;

	bool bExist_;
	bool detectModified_;
	DWORD tickcount_;

	bool deletePending_;
	DWORD deleteBeginTickCount_;
};


#endif
