#include "stdafx.hpp"
#include "FWatchApp.hpp"
#include "resource.h"

#include "FWatchSettingDlg.hpp"
#include "TaskSettingDialog.hpp"
#include "tstringUty.hpp"

#include <assert.h>

#include <commctrl.h>

#include "WaitCursor.hpp"



FWatchSettingDlg::FWatchSettingDlg()
	: hDlg_( NULL )
{
}

FWatchSettingDlg::~FWatchSettingDlg()
{
}

void FWatchSettingDlg::show( HWND hWnd )
{
	if( ::DialogBoxParam(
		pApp->getInstanceHandle(),
		MAKEINTRESOURCE( IDD_TASKLISTDIALOG ),
		hWnd,
		DlgProc,
		(LPARAM) this
		) == IDOK )
	{
		pApp->getCL().SaveInfData( pApp->getInfPath() );
	}
}

void FWatchSettingDlg::onInitDialog()
{
	HWND hList = ::GetDlgItem( hDlg_, IDC_LIST );
	assert( hList != NULL );

	const WatchTaskGroup& cl = pApp->getCL();

	// X^C̕ύX
	ListView_SetExtendedListViewStyle(hList,LVS_EX_FULLROWSELECT );

	// Jwb_̓o^
	LVCOLUMN data;
	data.mask = LVCF_TEXT | LVCF_WIDTH;
	data.cx = 100;
	const int colmx = GetColumnCount();
	for( int col=0; col<colmx; col++ ) {
		const tstring columnTitle = GetColTitle( col );
		data.pszText = (LPTSTR) columnTitle.c_str();
		ListView_InsertColumn( hList, col, &data );
	}

	// Xgڂ̒ǉ
	const int mx = cl.size();
	for( int idx=0; idx<mx; idx++ ) {
		LVITEM item;
		item.mask = LVIF_TEXT|LVIF_PARAM;
		item.iItem = idx;
		item.iSubItem = 0;
		item.pszText = _TEXT("");

		const int itemIndex = ListView_InsertItem( hList, &item );
		for( int col = 0; col<colmx; col++ ) {
			const tstring& disp = GetColText( idx, col );
			ListView_SetItemText(hList, itemIndex, col, (LPTSTR) disp.c_str() );
		}
	}

	displayStatus();
}

void FWatchSettingDlg::displayStatus() const
{
	HWND hStatus = ::GetDlgItem( hDlg_, IDC_THREADGROUP_STATUS );
	assert( hStatus != NULL );

	const WatchTaskGroup& cl = pApp->getCL();

	tstring status = pApp->LoadString( cl.isDryRun() ? IDS_TASKMES_MODEDRYRUN : IDS_TASKMES_MODESTANDALONE );
	if( cl.isModified() ) {
		status += pApp->LoadString( IDS_TASKMES_SETTINGDIRTY );
	}
	::SetWindowText( hStatus, status.c_str() );
}

void FWatchSettingDlg::onEdit( bool bEditMode )
{
	HWND hList = GetDlgItem(hDlg_,IDC_LIST);
	int sel = -1; // XgRg[̑Is
	if( bEditMode ) {
		// CłΌ݂̑I擾
		int i = 0;
		while(i < ListView_GetItemCount(hList)){
			if(ListView_GetItemState(hList,i,LVIS_SELECTED)){
				LVITEM item;
				item.mask = LVIF_PARAM;
				item.iItem = i;
				if(ListView_GetItem(hList,&item)){
					sel = i;
					break;
				}
			}
			i++;
		}
		if(sel < 0){
			// IĂȂΌx𔭂ďIB
			MessageBeep(MB_ICONERROR);
			return;
		}
	}

	WatchTaskGroup& cl = pApp->getCL();
	TaskSettingDialog sdlg( bEditMode ? cl.getInfo( sel ) : CSettingInfo() );
	if( sdlg.show( hDlg_ ) ) {
		const CSettingInfo info = sdlg.createSettingInfo();
		
		LVITEM item;
		item.mask = LVIF_TEXT|LVIF_PARAM;
		item.iSubItem = 0;
		item.pszText = _TEXT("");

		if( bEditMode ){
			cl.replace( sel, info );
			item.iItem = sel;
		}
		else {
			cl.append( info );
			sel = cl.size() - 1;
			item.iItem = sel;
			item.lParam = sel;
			ListView_InsertItem(hList,&item);
		}

		const int colmx = GetColumnCount();
		for( int col = 0; col<colmx; col++ ) {
			const tstring& disp = GetColText( sel, col );
			ListView_SetItemText( hList, sel, col, (LPTSTR)disp.c_str() );
		}
	}
}

void FWatchSettingDlg::onDelete()
{
	WaitCursor waitCursor;

	HWND hList = GetDlgItem(hDlg_,IDC_LIST);
	int idx = 0;
	while(idx < ListView_GetItemCount(hList)){
		if(ListView_GetItemState(hList,idx,LVIS_SELECTED)){
			pApp->getCL().erase( idx );
			ListView_DeleteItem( hList, idx );
			idx = 0;
			continue;
		}
		idx++;
	}
}

BOOL FWatchSettingDlg::onCommand( UINT btn )
{
	BOOL result = TRUE;
	switch(btn)
	{
	case IDOK:
		::EndDialog(hDlg_, IDOK);
		break;

	case IDCANCEL:
		::EndDialog(hDlg_, IDCANCEL);
		break;

	case IDC_ADD:
	case IDC_EDIT:
		onEdit( btn == IDC_EDIT );
		break;

	case IDC_DEL:
		onDelete();
		break;

	default:
		result = FALSE;
		break;
	}

	displayStatus();
	return FALSE;
}

BOOL FWatchSettingDlg::onNotify( WPARAM wParam, LPARAM lParam )
{
	const UINT uID = (UINT) wParam;
	const NMHDR* pNMHeader = (NMHDR*) lParam;
	
	if( uID == IDC_LIST ) {
		if( pNMHeader->code == NM_DBLCLK ) {
			const NMITEMACTIVATE* pNMItemActivate = (NMITEMACTIVATE*) pNMHeader;
			onEdit( true );
		}
		return TRUE;
	}

	return FALSE;
}

tstring FWatchSettingDlg::GetColTitle(int col) const
{
	//required:
	assert(col >= 0 && col < GetColumnCount() && "J͈̔͊OłB" );
	
	//do:
	return pApp->LoadString( IDS_SETTINGIDX0 + col );
}

int FWatchSettingDlg::GetColumnCount() const
{
	return 11;
}

tstring FWatchSettingDlg::GetColText( unsigned int idx, unsigned int col) const
{
	const WatchTaskGroup& cl = pApp->getCL();
	//required:
	assert( idx >= 0 && idx < cl.size() && "ACe͈̔͊OłB" );

	//do:
	const CSettingInfo& settingInfo = cl.getInfo( idx );
	switch(col)
	{
	case 0:
		return settingInfo.getWatchFile();
	case 1:
		return settingInfo.getWatchDir();
	case 2:
		return settingInfo.getAction();
	case 3:
		return settingInfo.getAppName();
	case 4:
		return settingInfo.getParam();
	case 5:
		return tstringuty::IntToString( settingInfo.getMaxProcess() );
	case 6:
		return settingInfo.getShowWindow().getDescription();
	case 7:
		return tstringuty::IntToString( settingInfo.getWaitWrite() );
	case 8:
		return tstringuty::IntToString( settingInfo.getTolerance() );
	case 9:
		return tstringuty::IntToString( settingInfo.getDeletePending() );
	case 10:
		return settingInfo.getLog();
	default:
		assert( false && "͈͊ÕJwłB" );
		return _TEXT("*ERR*");
	}
}

INT_PTR CALLBACK FWatchSettingDlg::DlgProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	FWatchSettingDlg* me = (FWatchSettingDlg*) ::GetWindowLongPtr( hDlg, DWLP_USER );
	assert( ( me == NULL || me->hDlg_ == hDlg ) && "QƂsłB" );

	if( message == WM_INITDIALOG ) {
		me = (FWatchSettingDlg*) lParam;
		assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
		::SetWindowLongPtr( hDlg, DWLP_USER, (LONG) me );
		me->hDlg_ = hDlg;
		me->onInitDialog();
	}
	else {
		if( message == WM_COMMAND ) {
			assert( me != NULL && "CX^Xւ̃|C^ݒ肳Ă܂B" );
			return me->onCommand( LOWORD(wParam) );
		}
		else if( message == WM_NOTIFY ) {
			return me->onNotify( wParam, lParam );
		}
	}
    return FALSE;
}

