#ifndef INCLUDE_H_DIRWATCHOBJECT
#define INCLUDE_H_DIRWATCHOBJECT

#include "PassiveTimer.hpp"
#include "tstring.hpp"

class DirWatchObject
{
public:
	DirWatchObject( const tstring& v_watchDir, bool v_enableSubDir, int v_retrySpan, int v_expirySpan, bool enableAPI_ );
	virtual ~DirWatchObject();
	
	HANDLE getHandle();
	
	void next();

	bool isNewHandle() const;

private:
	const tstring watchDir_;
	const bool enableSubDir_;
	const bool enableAPI_;

	HANDLE hWatchHandle_;
	bool bNewHandle_;

	PassiveTimer expiryTimer_;
	PassiveTimer retryTimer_;
};

#endif
