#include "stdafx.hpp"

#include "DelaySignal.hpp"

#include <assert.h>

DelaySignal::DelaySignal( int v_span, bool v_initialState ) throw()
	: span_( v_span )
	, lastTick_( 0 )
	, delaySignal_( false )
	, signaled_( v_initialState )
{
	assert( v_span >= 0 && "v_spanɕ̒l͎wł܂B" );
}

DelaySignal::~DelaySignal() throw()
{
}

void DelaySignal::setSignalDelay( DWORD v_now ) throw()
{
	lastTick_ = v_now;
	delaySignal_ = true;
}

void DelaySignal::setSignalImmediate() throw()
{
	signaled_ = true;
}

void DelaySignal::clear() throw()
{
	signaled_ = false;
	delaySignal_ = false;
}

bool DelaySignal::isSignaled( DWORD v_now ) const throw()
{
	if( ! signaled_ && delaySignal_ ) {
		signaled_ = ( span_ == 0 ) || ( v_now - lastTick_ ) > (DWORD) span_;
	}
	return signaled_;
}


