<html ng-app>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="Robots" content="NoIndex">

<head>
  <title>{$title}</title>
  <script src="//ajax.googleapis.com/ajax/libs/angularjs/1.2.25/angular.min.js"></script>
  <script type="text/javascript">
    var infostr    = '{$metainfo}';
    var arg_passwd = '{$passwd}';
    var arg_url    = '{$url}';
  {literal}
    function EditCtrl($scope) {
      $scope.info = JSON.parse( infostr );
      $scope.passwd = arg_passwd;
      $scope.url = arg_url;
      
      $scope.toDateStr = function(ts) {
        var d = new Date(ts * 1000 );
        var year  = d.getFullYear();
        var month = d.getMonth() + 1;
        var day   = d.getDate();
        var hour  = ( d.getHours()   < 10 ) ? '0' + d.getHours()   : d.getHours();
        var min   = ( d.getMinutes() < 10 ) ? '0' + d.getMinutes() : d.getMinutes();
        var sec   = ( d.getSeconds() < 10 ) ? '0' + d.getSeconds() : d.getSeconds();
        return year + '-' + month + '-' + day + ' ' + hour + ':' + min + ':' + sec ;
      };
      
      $scope.deltag = function(idx) {
        $scope.info.tags.splice(idx,1);
      };
      
      $scope.delfile = function(idx) {
        $scope.info.samefiles.splice(idx,1);
      };
      
      $scope.delcontact = function(idx) {
        $scope.info.contacts.splice(idx,1);
      };
      
      $scope.undoall = function() {
        $scope.info = JSON.parse( infostr );
      };
      
      $scope.jsonInfo = function () {
        return JSON.stringify( $scope.info );
      };
    }
  {/literal}
  </script>
</head>

<body ng-controller="EditCtrl" bgcolor="#FFFFEE" text="#800000" link="#0000EE" vlink="#0000EE" alink="#FF0000">

<h3>{$title}</h3>

<div>
<font color=red>個別編集ページ</font>
</div>

<font color=red>
指定ログのメタデータを直接手動で編集します<br>
変更には細心の注意を払ってください
</font>

<div>
<a href="./">トップページへ戻る</a>
</div>
<hr>

{$infotable}

<hr>

<table border=1>
{literal}
  <tr>
    <td>date </td>
    <td>更新時刻</td>
    <td><input type="number" ng-model="info.date" >{{toDateStr(info.date)}}</td>
  </tr>
  <tr>
    <td>first_date </td>
    <td>初回登録時刻</td>
    <td><input type="number" ng-model="info.first_date">{{toDateStr(info.first_date)}}</td>
  </tr>
  <tr>
    <td>user_update </td>
    <td>ユーザー更新時刻</td>
    <td><input type="number" ng-model="info.user_update" >{{toDateStr(info.user_update)}}</td>
  </tr>
  <tr>
    <td>title</td>
    <td>タイトル</td>
    <td><input type="text" ng-model="info.title"  size=100 ></td>
  </tr>
  <tr>
    <td>url </td>
    <td>取得元URL</td>
    <td><input type="text" ng-model="info.url"  size=100></td>
  </tr>
  <tr>
    <td>store_url </td>
    <td>公開URL(相対)</td>
    <td><input type="text" ng-model="info.store_url"  size=100 ></td>
  </tr>
  <tr>
    <td>thumb </td>
    <td>サムネイルURL(相対)</td>
    <td><input type="text" ng-model="info.thumb" size=100></td>
  </tr>
  <tr>
    <td>src1res_day</td>
    <td>1レス目日付</td>
    <td><input type="text" ng-model="info.src1res_day" size=100></td>
  </tr>
  <tr>
    <td>src1res_time</td>
    <td>1レス目時刻</td>
    <td><input type="text" ng-model="info.src1res_time" size=100></td>
  </tr>
  <tr>
    <td>res</td>
    <td>1レス目内容</td>
    <td><input type="text" ng-model="info.res" size=100></td>
  </tr>
  <tr>
    <td>res_count</td>
    <td>総レス数</td>
    <td><input type="number" ng-model="info.res_count" ></td>
  </tr>
  <tr>
    <td>lost </td>
    <td>404フラグ</td>
    <td><input type="checkbox" ng-model="info.lost" id="cklost"><label for="cklost">チェック</label></td>
  </tr>
  <tr>
    <td>ng</td>
    <td>更新NGフラグ</td>
    <td><input type="checkbox" ng-model="info.ng" id="ckng"><label for="ckng">チェック</label></td>
  </tr>
  <tr>
    <td>du </td>
    <td>キャッシュのディスク消費量</td>
    <td><input type="number" ng-model="info.du" ></td>
  </tr>

  <tr>
    <td>tags</td>
    <td>タグリスト</td>
    <td>
      <table>
        <tr ng-repeat="tag in info.tags">
          <td>{{tag[0]}}</td>
          <td>{{tag[1]}}</td>
          <td><input type="button" ng-click="deltag($index)" value="削除"></td>
        </tr>
      </table>
    </td>
  </tr>

  <tr>
    <td>samefiles</td>
    <td>関連ファイル</td>
    <td>
      <table>
        <tr ng-repeat="path in info.samefiles">
          <td>{{path}}</td>
          <td><input type="button" ng-click="delfile($index)" value="削除"></td>
        </tr>
      </table>
    </td>
  </tr>

  <tr>
    <td>contacts</td>
    <td>連絡</td>
    <td>
      <table>
        <tr ng-repeat="tag in info.contacts">
          <td>{{tag[0]}}</td>
          <td>{{tag[1]}}</td>
          <td><input type="button" ng-click="delcontact($index)" value="削除"></td>
        </tr>
      </table>
    </td>
  </tr>
{/literal}
</table>

<input type="button" ng-click="undoall()" 
onClick="javascript:return confirm('変更をすべて取り消しますか？')"
value="全て元に戻す">


{literal}
<form action="editmeta.php" method="post" onSubmit="return window.confirm('この内容で更新しますか？')">
  <input type="hidden" name="url" value="{{url}}">
  <input type="hidden" name="passwd" value="{{passwd}}">
  <input type="hidden" name="newvals" value="{{jsonInfo()}}">
  <input type="submit" value="データ更新">
</form>
{/literal}



</body>
</html>


