<?php

if(readConfig("USEFTSDB")){
  require_once 'fts_ftsdb.php';
}else{
  require_once 'fts_flatdb.php';
}



//全文検索用のDBインスタンスを作成する
function makeFullTextDB()
{
  if(readConfig("USEFTSDB")){
    return new FulltextFTSDB();
  }else{
    return new FullTextDB();
  }
}

function _scrapingText($url){
  $basenames = urlToBasename( $url );
  $filepath = readConfig("CONTDIR") . $basenames["CONT"] . _PGET_INDEX_PAGE_;

  //ギャラザのようなことをする
  $textutf8 = mb_convert_encoding(file_get_contents($filepath), "UTF8", "SJIS");
  $fixtext = "";

  //レスを抽出
  if(preg_match_all( '/<blockquote[^>]*>(.*?)<\/blockquote>/i', $textutf8, $matches, PREG_PATTERN_ORDER) )
  {
    foreach($matches[1] as $restext) {

      $restext = preg_replace('/<[^>]+>/i','',$restext);

      $fixtext .= $restext;
    }
  }
  return $fixtext;
}


//インデックス更新
function UpdateSearchIndex($meta) {
  if(readConfig("USESEARCHSV")) {
    $sv = makeFullTextDB();
    //if($meta['lost'] && !$sv->Get( $meta['url'] )){
      $fixtext = _scrapingText($meta['url']);
      //DBに登録
      $sv->Put( $meta['url'], $fixtext, $meta['lost']);
    //}
    $sv->close();
  }
}
