<?php

/**
 * ハッシュを元にスレッド情報をグループ化し
 * 各グループ毎のチャンクファイルに格納するkvs
 *
 * windows+php4環境で動作し一覧性能に優れる
**/

require_once 'DBA_flatfile.php';

class DBA_Chunkfile{
  var $dbpath;
  var $lock;
  var $pool;
  var $write;

  function DBA_Chunkfile()
  {
    $this->dbpath = readConfig("METADIR") . "chunk";
    $lockpath = $this->dbpath . ".lck";
    $this->lock = fopen($lockpath, "w") or die("can't open chunk.lck");
    flock($this->lock, LOCK_EX) or die("can't lock chunk.lck");

    $this->pool = array();
    $this->write = false;

    if(!file_exists($this->dbpath)) {
      mkdir($this->dbpath);

      //flatfileからのデータ引き継ぎ
      $flat = new DBA_Flatfile('w');
      foreach($flat->allKeys() as $key){
        $info = $flat->get($key);
        $this->set($key, $info);
        $flat->del($key);
      }
      $flat->close();
      $this->_flush();
    }
  }

  function close()
  {
    //sync
    if( $this->write ){
      $this->_flush();
    }

    flock($this->lock, LOCK_UN);
    fclose($this->lock);
  }

  function optimize(){}

  function get($key, $default=false)
  {
    $poolKey = $this->_getPoolKey($key);
    if(array_key_exists($key,$this->pool[$poolKey])){
      return $this->pool[$poolKey][$key];
    }else{
      return $default;
    }
  }

  function set($key, $value)
  {
    $this->write = true;
    $poolKey = $this->_getPoolKey($key);
    $this->pool[$poolKey][$key] = $value;
  }

  function del($key)
  {
    $this->write = true;
    $poolKey = $this->_getPoolKey($key);
    if(array_key_exists($key,$this->pool[$poolKey])){
      unset($this->pool[$poolKey][$key]);
    }
  }

  function exists($key)
  {
    $poolKey = $this->_getPoolKey($key);
    return array_key_exists($key,$this->pool[$poolKey]);
  }

  function allKeys()
  {
    $book = $this->_getBook();
    return array_keys($book);
  }

  function allValues()
  {
    $book = $this->_getBook();
    $infos = array();
    $dates = array();

    foreach(array_keys($book) as $key){
      $info = $book[$key];
      $infos[] = $info;
      $dates[] = $info["date"];
    }

    array_multisort($dates, SORT_DESC, $infos);

    return $infos;
  }

  //private:==========================================
  function _getPoolKey($key) {
    $chunkPath = $this->_getChunkPath($key);
    if(!array_key_exists ( $chunkPath, $this->pool )){
      if(is_file($chunkPath)){
        $chunkBin = file_get_contents($chunkPath);
        $chunk = unserialize($chunkBin);
        $this->pool[$chunkPath] = $chunk;
      }else{
        $this->pool[$chunkPath] = array();
      }
    }
    return $chunkPath;
  }

  function _getChunkPath($key) {
    $hash = md5($key);
    $idx = intval(substr($hash, 0, 2), 16) % 64;
    return $this->dbpath . "/$idx.chunk";
  }

  function _getAllChunkPath() {
    $result = array();
    for($i = 0; $i < 64; $i += 1){
      $result[] = $this->dbpath . "/$i.chunk";
    }
    return $result;
  }

  function _getBook(){
    $book = array();
    foreach($this->_getAllChunkPath() as $chunkPath){
      $chunk = array();
      if(array_key_exists ( $chunkPath, $this->pool )){
        $chunk = $this->pool[$chunkPath];
      }else if(file_exists($chunkPath)){
        $chunkBin = file_get_contents($chunkPath);
        $chunk = unserialize($chunkBin);
        $this->pool[$chunkPath] = $chunk;
      }
      $book = array_merge($book, $chunk);
    }
    return $book;
  }

  function _flush(){
    foreach( array_keys($this->pool) as $chunkPath ){
      $bin = serialize($this->pool[$chunkPath]);
      file_put_contents($chunkPath, $bin);
    }
  }

};
