<?php

/**
 * ダウンロードページ
 *
 * GET
 *  rooturl 元のスレッドurl
 *  type    ファイル形式(zip/mht)
 *  dlname  ダウンロードファイル名
**/

require_once 'config.php';
require_once 'phplib/session.php';
require_once 'phplib/crawl/httprequest.php';
init_session();

$secretkey = "<secretkey>";
$targeturl = get_current_uri_dir() . "download.php?" . http_build_query($_GET);

//echo $targeturl;
function createLink($targeturl, $secretkey) {
  try{

    $request2 = new HTTP_Request2();
    $request2->setConfig(array(
        'ssl_capath' => '/etc/ssl/certs',
    ));
    $request2->setUrl('https://api.coinhive.com/link/create');
    $request2->setMethod(HTTP_Request2::METHOD_POST);

    $request2->addPostParameter('url', $targeturl);
    $request2->addPostParameter('hashes', 1024);
    $request2->addPostParameter('secret', $secretkey);

    // リクエストを送信※上記パラメータで設定した値をPOSTで送信する。
    $result = $request2->send();

    // レスポンスのボディ部を表示※送信先のPHPファイルが出力した文字列を受け取る。
    return json_decode( $result->getBody() , true);

  // HTTP_Request2のエラーを表示
  } catch( HTTP_Request2_Exception $e ){
    die($e->getMessage());
  // それ以外のエラーを表示
  } catch (Exception $e){
    die($e->getMessage());
  }
}

$link = createLink($targeturl,$secretkey);
header( "HTTP/1.1 301 Moved Permanently" );
if($link["success"]){
  header("Location: " . $link["url"]);
}else{
  header("Location: " . $targeturl);
}
exit;
