<?php
/**
 * 指定urlのスレを保存する
 *
 * GETパラメータ
 *  rooturl 取得対象のURL
 *
 */

require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'phplib/common.php';
require_once 'phplib/crawl.php';
require_once 'phplib/result.php';
require_once 'phplib/archive/pzip.php';
require_once 'phplib/imgfinder.php';
require_once 'phplib/filehashing.php';

require_once 'blacklist.php';
require_once 'autotag.php';

//----------------------------------
//query param

//$GETURL=trim($_GET["rooturl"]); 
$GETURL=urldecode(trim($_GET["rooturl"]));

//-----------------------------------------------------------------
//function

/*
 *スレッド保持数上限を超えた場合
 *更新時刻が古い物を削除する
*/
function removeSurplus() {


  if(readConfig('LIMITCAP') > 0) {
    $limit = readConfig('LIMITCAP');
    $metaInfoList = readAllInfo () ;
    if(count($metaInfoList) > $limit) {
      $removeList = array_slice($metaInfoList,$limit);

      foreach($removeList as $info) {
        $bases = urlToBasename($info["url"]);

        log2file("removeSurplus " . $info["url"] );

        removePage($info["url"]);
      }
    }
  }
}

function pgetGetImageList ($urls)
{
  ob_start();

  echo '<html><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">' . "\n";
  echo "<head><script>var imgcnt = " . count($urls) . "; var getcnt = 0; </script>\n";
}
function pgetGetImage($url,$success)
{
  echo '<script> getcnt += 1; document.title = String(getcnt) + " / " + String(imgcnt)</script>' . "\n";
  flush();
  ob_end_flush();
  ob_start();
}
function pgetCloseHead($title)
{
  echo '<script> document.title = "done ' . $title . '"; </script>' . "\n";
  echo "";
  echo "</head>\n";

  flush();
  ob_end_flush();
}

//-----------------------------------------------------------------
//ダウンロード
function updateLog($GETURL) {
  //キャッシュ経由、または自前でスレの更新を試みる
  if ($info = execDownload($GETURL,'pgetGetImageList','pgetGetImage')) {
    pgetCloseHead($info["url"]);
  }else{
    //双葉、キャッシュ、自分の何処にもスレが無いため
    //保険用のバケットから取得を試みる
    $suretyHosts = readConfig("SUBSCRIBES", array());
    foreach($suretyHosts as $hostUrl) {
      $info = getFromRemote( $hostUrl, $GETURL, false);
      if($info){
        //とれたログの加工をpgetモジュールに依頼する
        $basenames = urlToBasename($GETURL);
        $dldirname = $basenames["CONT"];
        $dldir = readConfig("CONTDIR") . $dldirname;
        cust_pget($GETURL,$dldir,'pgetDmyGetImageList','pgetDmyGetImage',true);
        
        UpdateSearchIndex($info);
        break;
      }
    }
  }
  return $info;
}

function updateInfo($info) {
  //ユーザー更新時間を設定
  $info['user_update'] = $info ['date'];

  //保存ユーザーを記録
  if(readConfig("STOCKLIST")){
    $allid = get_value($info,'alluserid',array());
    if(!in_array(read_regid(), $allid)){
      $allid[] = read_regid();
      $info['alluserid'] = $allid;
      removeJsonApiCache();
    }
  }

  //メタデータのセーブ
  saveInfo($info);
}

//-----------------------------------------------------------------
//body

//ホストがブラックリストに無いかチェック
if (isWriteBlockHost(getClientIp())) {
  echo errorPage( "アクセス規制中です" );
  return ;
}

// 購読先バケットから取り込めるようにurlを加工する
$subscribes = readConfig("SUBSCRIBES", array());
if( strlen(readConfig("REMOTEROOT",""))>0) {
  $subscribes[] = readConfig("REMOTEROOT");
}
$subscribes[] = get_current_uri_dir();
foreach( $subscribes as $surety ){
  if(strpos( $GETURL, $surety ) === 0){
    $dst = preg_replace("/\/[^\/]*$/i","",$GETURL);        //dirname
    $dst = preg_replace("/^.*\//i","",$dst);               //basename
    $dst = "http://" . str_replace("_","/",$dst) . ".htm"; //tourl
    $GETURL = $dst;
    break;
  }
}

$page = false;

//ふたばのスレッドのurlのみ受け付ける
if (preg_match(readConfig("URLREGX") , $GETURL )){

  $basenames = urlToBasename($GETURL);

  $lockpath = readConfig("LOCKDIR") . $basenames["LOCK"];
  //ロック処理(同一スレッドのダウンロードの排他)

  $info = false;

  $info = readUrlInfo($GETURL);

  if(!readConfig("MANUALUPDATE") && $info) {
    //手動更新無効かつ場合は
    //(新規取得ではない)更新自体はcron_get.phpにまかせる
    updateInfo($info);
    $page = resultPage($info);
  }else{
    if($info && $info["date"] + readConfig("COOLTIME") > time() ){
      //連続更新禁止
      $page = errorPage( "更新は時間を置いてください", $info );
    }else if($lock = fopen($lockpath, 'w')){
      if (flock($lock, LOCK_EX)){

        $oldInfo = $info;
        //ロックできた場合はダウンロードを行う。
        $info = updateLog($GETURL);

        if($info){
          updateInfo($info);
        }

        if($info && (!$info["lost"] || !$oldInfo)) {
          //結果ページの表示
          $page = resultPage($info);
        }else{
          $page = errorPage( "スレッドのダウンロードに失敗しました", $info );
        }

        flock($lock, LOCK_UN);

        //保持スレッド数制限
        removeSurplus();
      }

      fclose($lock);
    }
  }

  //自動付加できるタグを追加
  if($info) {
    foreach( getAutotag($info) as $tag ){
      addtag($info["url"], $tag , "");
    }
  }

  //画像検索システムに登録
  imgfinder_update($info["url"]);
  //ファイルハッシュを登録
  filehash_update($info["url"]);

}else{
  $page = errorPage( "ふたばのスレッドurlを指定してください。 リクエストしたURL ->("  . $GETURL . ")" );
}

echo $page;

