<?php

/**
 * sqlite3に全レス格納し全文検索するためのモジュール
 * like検索のため件数が増えると遅くなる
 * 心地よく使えるのは3000件程度が上限
*/

class FullTextDB
{
  var $lock;
  var $con;
  
  function FullTextDB()
  {
    $lockpath = readConfig("LOCKDIR") . "fulltext.lock";
    $this->lock = fopen($lockpath, 'w');
    flock($this->lock, LOCK_EX) or die("can't lock fulltext.lock");
    
    $this->con = new SQLite3(readConfig("METADIR") . 'fulltext.sqlite');
    
    $this->con->exec(
      "create table if not exists fulltext  ".
      " (url text, restext text, PRIMARY KEY(url)) ");
    $this->con->exec("pragma synchronous=off;");
    $this->con->exec("pragma journal_mode=memory;");
  }
  
  /// リソースの開放
  function close(){
    $this->con->close();
    flock($this->lock, LOCK_UN);
    fclose($this->lock);
  }
  
  function optimize()
  {
    $this->con->exec("VACUUM");
  }

  // ドキュメントの追加/更新
  function Put( $url, $restext)
  {
    $stmt = $this->con->prepare(
      " REPLACE INTO fulltext ".
      " values(:url,:restext) ");
    
    $stmt->bindValue(":url", $url, SQLITE3_TEXT );
    $stmt->bindValue(":restext", $restext, SQLITE3_TEXT );
    $stmt->execute();
  }
  
  // ドキュメントの削除
  function Del( $url )
  {
    $stmt = $this->con->prepare(
      "delete from fulltext ".
      " where url =:url ");
    $stmt->bindValue(":url", $url, SQLITE3_TEXT );
    $stmt->execute();
  }
  
  // ドキュメントの取得
  function Get( $url )
  {
    $stmt = $this->con->prepare(
      "select restext from fulltext ".
      " where url =:url ");
    $stmt->bindValue(":url", $url, SQLITE3_TEXT );
    
    $result = $stmt->execute();
    $arr = $result->fetchArray(SQLITE3_NUM);
    
    if($arr){
      return $arr[0];
    }else{
      return false;
    }
  }
  
  //指定の単語でドキュメントを検索
  function Search( $query )
  {
    $stmt = $this->con->prepare(
      "select url from fulltext ".
      " where restext like :query");
    $stmt->bindValue(":query", '%'.$query.'%', SQLITE3_TEXT );
    $result = $stmt->execute();
    
    $urls = array();
    while($result && $arr = $result->fetchArray(SQLITE3_NUM)){
      $urls[] = $arr[0];
    }
    
    return $urls;
  }
};

