/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "fb-prefs.h"
#include "fb-conf.h"
#include "prefs-viewer.h"
#include "fb-image.h"

typedef struct _FbPrefsViewer
{
	GtkWidget *button1;
	GtkWidget *spin1;
	GtkWidget *spin2;
	GtkWidget *spin3;
	gboolean changed;
} FbPrefsViewer;

static void cb_change_monitor(void);
static GtkWidget *prefs_viewer_new (void);
static void prefs_viewer_apply(void);
static void prefs_viewer_destroy(void);

static FbPrefsFunc prefs_func = {
	create: prefs_viewer_new,
	apply: prefs_viewer_apply,
	destroy: prefs_viewer_destroy,
};

static FbPrefsViewer *prefs_ui;

static void
cb_change_monitor(void)
{
	prefs_ui->changed = TRUE;
}

static GtkWidget *
prefs_viewer_new(void)
{
	gint val_i;
	gfloat val_f;
	GSList *rgroup;
	GtkWidget *main_vbox, *vbox, *hbox, *table, *frame;
	GtkWidget *button, *button1, *label;
	GtkWidget *spin1, *spin2, *spin3;

	prefs_ui = g_new0(FbPrefsViewer, 1);

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);

	/* open way */
	frame = gtk_frame_new(_("Open Way"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	button = gtk_radio_button_new_with_label(NULL, _("Right"));
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	rgroup =  gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	button1 = gtk_radio_button_new_with_label(rgroup, _("Left"));
	g_signal_connect(G_OBJECT(button1), "clicked",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_box_pack_start(GTK_BOX(vbox), button1, FALSE, FALSE, 0);
	gtk_widget_show(button1);

	fb_conf_get_value ("open way", &val_i, FB_CONF_TYPE_INT, "1");
	if (val_i == RIGHT_OPEN)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
	else if (val_i == LEFT_OPEN)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1), TRUE);

	/* zoom */
	frame = gtk_frame_new(_("Magnifying Lens"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	table = gtk_table_new(2, 4, TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("Width :"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 0, 1,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	fb_conf_get_value ("magnify width", &val_i, FB_CONF_TYPE_INT, "100");
	spin1 = gtk_spin_button_new_with_range(20, 300, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin1), val_i);
	g_signal_connect(G_OBJECT(spin1), "value-changed",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), spin1,
			 1, 2, 0, 1,
			 0, 0,
			 0, 0);
	gtk_widget_show(spin1);

	label = gtk_label_new(_("Height :"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 1, 2,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	fb_conf_get_value ("magnify height", &val_i, FB_CONF_TYPE_INT, "100");
	spin2 = gtk_spin_button_new_with_range(20, 300, 1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin2), val_i);
	g_signal_connect(G_OBJECT(spin2), "value-changed",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), spin2,
			 1, 2, 1, 2,
			 0, 0,
			 0, 0);
	gtk_widget_show(spin2);

	label = gtk_label_new(_("Scale :"));
	gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 2, 3, 1, 2,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	fb_conf_get_value ("magnify power", &val_f, FB_CONF_TYPE_FLOAT, "1.5");
	spin3 = gtk_spin_button_new_with_range(1.2, 5.0, 0.1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin3), val_f);
	g_signal_connect(G_OBJECT(spin3), "value-changed",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), spin3,
			 3, 4, 1, 2,
			 0, 0,
			 0, 0);
	gtk_widget_show(spin3);

	prefs_ui->button1 = button1;
	prefs_ui->spin1 = spin1;
	prefs_ui->spin2 = spin2;
	prefs_ui->spin3 = spin3;
	prefs_ui->changed = FALSE;

	return main_vbox;
}

static void
prefs_viewer_apply(void)
{
	gint val_i;
	gfloat val_f;

	if (! prefs_ui->changed) return;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_ui->button1)))
		val_i = LEFT_OPEN;
	else
		val_i = RIGHT_OPEN;
	fb_conf_set_value ("open way", &val_i, FB_CONF_TYPE_INT);

	val_i = gtk_spin_button_get_value(GTK_SPIN_BUTTON(prefs_ui->spin1));
	fb_conf_set_value ("magnify width", &val_i, FB_CONF_TYPE_INT);
	val_i = gtk_spin_button_get_value(GTK_SPIN_BUTTON(prefs_ui->spin2));
	fb_conf_set_value ("magnify height", &val_i, FB_CONF_TYPE_INT);

	val_f = gtk_spin_button_get_value(GTK_SPIN_BUTTON(prefs_ui->spin3));
	fb_conf_set_value ("magnify power", &val_f, FB_CONF_TYPE_FLOAT);

	prefs_ui->changed = FALSE;
}

static void
prefs_viewer_destroy(void)
{
	g_free(prefs_ui);
}

FbPrefsFunc *
prefs_viewer_get_func(void)
{
	return &prefs_func;
}
