/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "fb-prefs.h"
#include "fb-conf.h"
#include "prefs-general.h"

typedef struct _FbPrefsGeneral
{
	GtkWidget *home_button;
	GtkWidget *home_entry;
	GtkWidget *archive_button;
	GtkWidget *archive_entry;

	gboolean changed;
} FbPrefsGeneral;

static void cb_change_monitor (void);
static GtkWidget *prefs_general_new (void);
static void prefs_general_set_value (void);
static void prefs_general_apply(void);
static void prefs_general_destroy(void);

static FbPrefsFunc prefs_func =
{
	create: prefs_general_new,
	apply: prefs_general_apply,
	destroy: prefs_general_destroy,
};

static FbPrefsGeneral *prefs_ui;

static void
cb_change_monitor (void)
{
	prefs_ui->changed = TRUE;
}

static GtkWidget *
prefs_general_new(void)
{
	GSList *group;
	GtkWidget *main_vbox, *vbox, *table, *frame, *align;
	GtkWidget *button, *label;

	prefs_ui = g_new0(FbPrefsGeneral, 1);
	prefs_ui->changed = FALSE;

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);

	frame = gtk_frame_new(_("Start page"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	table = gtk_table_new(4, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("This is directory displayed at first"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 2, 0, 1,
			 GTK_FILL, 0,
			 5, 0);
	gtk_widget_show(label);

	button = gtk_radio_button_new_with_label(NULL, _("Last Visited Location"));
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), button,
			 0, 2, 1, 2,
			 GTK_FILL, 0,
			 5, 0);
	gtk_widget_show(button);

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button));

	prefs_ui->home_button = gtk_radio_button_new_with_label(group, _("Home Location"));
	g_signal_connect(G_OBJECT(prefs_ui->home_button), "clicked",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), prefs_ui->home_button,
			 0, 2, 2, 3,
			 GTK_FILL, 0,
			 5, 0);
	gtk_widget_show(prefs_ui->home_button);

	frame = gtk_frame_new(_("Enter Home Location"));
	gtk_table_attach(GTK_TABLE(table), frame,
			 0, 2, 3, 4,
			 GTK_FILL | GTK_EXPAND, 0,
			 2, 2);
	gtk_widget_show(frame);

	align = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
	gtk_alignment_set_padding(GTK_ALIGNMENT(align), 0, 2, 2, 2);
	gtk_container_add(GTK_CONTAINER(frame), align);
	gtk_widget_show(align);

	prefs_ui->home_entry = gtk_entry_new();
	g_signal_connect(G_OBJECT(prefs_ui->home_entry), "key-release-event",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_container_add(GTK_CONTAINER(align), prefs_ui->home_entry);
	gtk_widget_show(prefs_ui->home_entry);

	frame = gtk_frame_new(_("Archive Extract"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox);
	gtk_widget_show (vbox);

	prefs_ui->archive_button = gtk_check_button_new_with_label (_("Remove archive extracted when finish futaba"));
	g_signal_connect (G_OBJECT (prefs_ui->archive_button), "toggled",
			  G_CALLBACK (cb_change_monitor), NULL);
	gtk_box_pack_start (GTK_BOX (vbox), prefs_ui->archive_button, FALSE, FALSE, 0);
	gtk_widget_show (prefs_ui->archive_button);

/* 	frame = gtk_label_new (_("Specify directory extracting archive.")); */
/* 	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0); */
/* 	gtk_widget_show (frame); */

/* 	prefs_ui->archive_entry = gtk_entry_new (); */
/* 	g_signal_connect(G_OBJECT(prefs_ui->archive_entry), "key-release-event", */
/* 			 G_CALLBACK(cb_change_monitor), NULL); */
/* 	gtk_container_add(GTK_CONTAINER(frame), prefs_ui->archive_entry); */
/* 	gtk_widget_show(prefs_ui->archive_entry); */

	prefs_general_set_value ();

	return main_vbox;
}

static void
prefs_general_set_value (void)
{
	gboolean flag;
	gchar *value;

	fb_conf_get_value ("start home", &flag, FB_CONF_TYPE_BOOLEAN, NULL);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(prefs_ui->home_button), flag);

	fb_conf_get_value ("home page", &value, FB_CONF_TYPE_STRING, NULL);
	gtk_entry_set_text (GTK_ENTRY(prefs_ui->home_entry), value);
	g_free (value);

	fb_conf_get_value ("remove extracted archive", &flag, FB_CONF_TYPE_BOOLEAN, NULL);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (prefs_ui->archive_button), flag);

/* 	fb_conf_get_value ("extract path", &value, FB_CONF_TYPE_STRING, NULL); */
/* 	gtk_entry_set_text (GTK_ENTRY (prefs_ui->archive_entry), value); */
/* 	g_free (value); */
}

static void
prefs_general_apply(void)
{
	gboolean flag;
	gchar *text, *value;

	if (! prefs_ui->changed) return;

	flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_ui->home_button));
	fb_conf_set_value ("start home", &flag, FB_CONF_TYPE_BOOLEAN);

	text = gtk_editable_get_chars(GTK_EDITABLE (prefs_ui->home_entry), 0, -1);
	value = g_locale_from_utf8 (text, -1, NULL, NULL, NULL);
	fb_conf_set_value ("home page", value, FB_CONF_TYPE_STRING);
	g_free (text);
	g_free (value);

	flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_ui->archive_button));
	fb_conf_set_value ("remove extracted archive", &flag, FB_CONF_TYPE_BOOLEAN);

/* 	text = gtk_editable_get_chars(GTK_EDITABLE (prefs_ui->archive_entry), 0, -1); */
/* 	value = g_locale_from_utf8 (text, -1, NULL, NULL, NULL); */
/* 	fb_conf_set_value ("extract path", value, FB_CONF_TYPE_STRING); */
/* 	g_free (text); */
/* 	g_free (value); */

	prefs_ui->changed = FALSE;
}

static void
prefs_general_destroy(void)
{
	g_free (prefs_ui);
}

FbPrefsFunc *
prefs_general_get_func(void)
{
	return &prefs_func;
}

