/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "fb-prefs.h"
#include "futaba.h"
#include "fb-conf.h"
#include "prefs-filter.h"

typedef struct _FbPrefsFilter
{
	GtkWidget *button1;
	GtkWidget *button2;

	GtkWidget *label1;
	GtkWidget *label2;

	gboolean changed;
} FbPrefsFilter;

enum {
	COLUMN_APPLY,
	COLUMN_MIME,
	NUM_COLUMNS
};

static void cb_change_monitor(void);
static GtkWidget *prefs_filter_new (void);
static void prefs_filter_apply(void);
static void prefs_filter_destroy(void);

static FbPrefsFunc prefs_func = {
	create: prefs_filter_new,
	apply: prefs_filter_apply,
	destroy: prefs_filter_destroy,
};

static FbPrefsFilter *prefs_ui;

static void
cb_change_monitor(void)
{
	prefs_ui->changed = TRUE;
}

static void
cb_cell_toggled(GtkCellRendererToggle *cell,
		gchar *path_str,
		gpointer data)
{
	gboolean is_active;
	GtkTreeIter iter;
	GtkTreePath *tpath = gtk_tree_path_new_from_string(path_str);
	GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(data));

	gtk_tree_model_get_iter(model, &iter, tpath);
	gtk_tree_model_get(model, &iter,
			   COLUMN_APPLY, &is_active,
			   -1);

	gtk_list_store_set(GTK_LIST_STORE(model), &iter,
			   COLUMN_APPLY, !is_active,
			   -1);

	gtk_tree_path_free(tpath);
}

static GtkListStore *
filter_list_new(void)
{
	GtkListStore *list;
	GtkTreeIter iter;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *col;

	list = gtk_list_store_new(NUM_COLUMNS,
				  G_TYPE_BOOLEAN,
				  G_TYPE_STRING,
				  -1);

	gtk_list_store_append(list, &iter);
	gtk_list_store_set(list, &iter,
			   COLUMN_APPLY, TRUE,
			   COLUMN_MIME, "TEST",
			   -1);

	return list;
}

static GtkWidget *
prefs_filter_new(void)
{
	GtkListStore *list;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *col;
	GtkSizeGroup *group;
	GtkWidget *main_vbox, *vbox, *hbox, *table, *frame;
	GtkWidget *scrolled, *treeview;
	GtkWidget *button1, *button2, *label, *label1, *label2;

	prefs_ui = g_new0(FbPrefsFilter, 1);

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);

	button1 = gtk_check_button_new_with_label(_("Don't display \".\""));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1), cdir_filter);
	g_signal_connect(G_OBJECT(button1), "toggled",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_box_pack_start(GTK_BOX(main_vbox), button1, FALSE, FALSE, 0);
	gtk_widget_show(button1);

	button2 = gtk_check_button_new_with_label(_("Don't display \"..\""));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button2), pdir_filter);
	g_signal_connect(G_OBJECT(button2), "toggled",
			 G_CALLBACK(cb_change_monitor), NULL);
	gtk_box_pack_start(GTK_BOX(main_vbox), button2, FALSE, FALSE, 0);
	gtk_widget_show(button2);

	/* filter list */
	scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolled),
					    GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(main_vbox), scrolled, TRUE, TRUE, 0);
/* 	gtk_widget_show(scrolled); */

	treeview = gtk_tree_view_new();
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), FALSE);
	gtk_container_add(GTK_CONTAINER(scrolled), treeview);
	gtk_widget_show(treeview);

	col = gtk_tree_view_column_new();
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

	renderer = gtk_cell_renderer_toggle_new();
	g_signal_connect(G_OBJECT(renderer), "toggled",
			 G_CALLBACK(cb_cell_toggled), treeview);
	gtk_tree_view_column_pack_start(col, renderer, FALSE);
	gtk_tree_view_column_set_attributes(col, renderer,
					    "active", COLUMN_APPLY,
					    NULL);

	col = gtk_tree_view_column_new();
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_column_pack_start(col, renderer, FALSE);
	gtk_tree_view_column_set_attributes(col, renderer,
					    "text", COLUMN_MIME,
					    NULL);

	list = filter_list_new();
	gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), GTK_TREE_MODEL(list));

	/* display detail */
	frame = gtk_frame_new(_("Detail"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
/* 	gtk_widget_show(frame); */

	table = gtk_table_new(2, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("Description:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 0, 1,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	label = gtk_label_new(_("Extensions:"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 1, 1, 2,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label);

	label1 = gtk_label_new("test TEST test");
	gtk_misc_set_alignment(GTK_MISC(label1), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label1,
			 1, 2, 0, 1,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label1);

	label2 = gtk_label_new("TEST");
	gtk_misc_set_alignment(GTK_MISC(label2), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label2,
			 1, 2, 1, 2,
			 GTK_FILL, 0,
			 10, 0);
	gtk_widget_show(label2);

	prefs_ui->button1 = button1;
	prefs_ui->button2 = button2;
	prefs_ui->label1 = label1;
	prefs_ui->label2 = label2;
	prefs_ui->changed = FALSE;

	return main_vbox;
}

static void
prefs_filter_apply(void)
{
	if (!prefs_ui->changed) return;

	cdir_filter = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_ui->button1));
	pdir_filter = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_ui->button2));

	prefs_ui->changed = FALSE;
}

static void
prefs_filter_destroy(void)
{
	g_free(prefs_ui);
}

FbPrefsFunc *
prefs_filter_get_func(void)
{
	return &prefs_func;
}

