/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_WINDOW_H__
#define __FB_WINDOW_H__

#define FB_TYPE_WINDOW			(fb_window_get_type ())
#define FB_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_WINDOW, FbWindow))
#define FB_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_WINDOW, FbWindowClass))
#define FB_IS_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_WINDOW))
#define FB_IS_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_WINDOW))
#define FB_WINDOW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_WINDOW, FbWindowClass))

typedef struct _FbWindow      FbWindow;
typedef struct _FbWindowClass FbWindowClass;

struct _FbWindow
{
	GtkWindow parent;

	GtkWidget *tool_bar;
	GtkWidget *location_bar;
	GtkWidget *entry;
	GtkWidget *status_bar;

	GtkUIManager *ui_manager;

	GtkWidget *dirview;
	GtkWidget *preview;

	gboolean archive_opened;
};

struct _FbWindowClass
{
	GtkWindowClass parent_class;
};

GType             fb_window_get_type         (void);

GtkWidget        *fb_window_new              (const gchar *path);

void              fb_window_store_state      (FbWindow    *fb);

void              fb_window_add_bookmark     (FbWindow    *fb,
					      const gchar *path);

void              fb_window_remove_bookmark  (FbWindow    *fb,
					      gint         nth);
/* utils func */
void              ui_set_sensitive           (GtkUIManager  *ui_manager,
					      const gchar   *path,
					      gboolean       is_sensitive);

void              ui_set_active              (GtkUIManager  *ui_manager,
					      const gchar   *path,
					      gboolean       is_active);

void              ui_set_message             (GtkUIManager  *ui_manager,
					      const gchar   *path,
					      const gchar   *message);

void              widget_set_message         (GtkWidget     *wg,
					      const gchar   *message);

#endif /* __FB_WINDOW_H__ */
