/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_THUMBWIN_H__
#define __FB_THUMBWIN_H__

#define FB_TYPE_THUMBWIN		(fb_thumbwin_get_type ())
#define FB_THUMBWIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_THUMBWIN, FbThumbWin))
#define FB_THUMBWIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_THUMBWIN, FbThumbWinClass))
#define FB_IS_THUMBWIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_THUMBWIN))
#define FB_IS_THUMBWIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_THUMBWIN))
#define FB_THUMBWIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_THUMBWIN, FbThumbWinClass))

enum {
	THUMBWIN_PIXBUF,
	THUMBWIN_TEXT,
	THUMBWIN_PATH,
	THUMBWIN_COLUMNS
};

typedef struct _FbThumbWin      FbThumbWin;
typedef struct _FbThumbWinClass FbThumbWinClass;

struct _FbThumbWin
{
	GtkWindow parent;

	GtkWidget *scroll;
	GtkWidget *icon_view;
	GtkWidget *popup1;
	GtkWidget *popup2;

	GtkUIManager *ui_manager;

	GtkListStore *store;
	GtkTreePath *prev_path;

	gchar *workdir;

	gint thumb_w, thumb_h;
	gint thumb_spacing;

	gchar *drag_data;
};


struct _FbThumbWinClass
{
	GtkWindowClass parent_class;
};

extern GtkWidget *focus_thumbwin;

GType             fb_thumbwin_get_type            (void);

GtkWidget        *fb_thumbwin_new                 (void);

void              fb_thumbwin_start               (GList       *path_list);

void              fb_thumbwin_add_thumbnail       (FbThumbWin  *tw,
						   const gchar *path);

void              fb_thumbwin_set_background      (FbThumbWin  *tw,
						   const gchar *path);

GList            *fb_thumbwin_get_selected_items  (FbThumbWin  *tw);

void              fb_thumbwin_update_thumbnail    (FbThumbWin *tw);

void              fb_thumbwin_update_title        (FbThumbWin *tw);

#endif /* __FB_THUMBWIN_H__ */
