/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_LOCATIONBAR_H__
#define __FB_LOCATIONBAR_H__

#define FB_TYPE_LOCATIONBAR			(fb_locationbar_get_type ())
#define FB_LOCATIONBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_LOCATIONBAR, FbLocationbar))
#define FB_LOCATIONBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_LOCATIONBAR, FbLocationbarClass))
#define FB_IS_LOCATIONBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_LOCATIONBAR))
#define FB_IS_LOCATIONBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_LOCATIONBAR))
#define FB_LOCATIONBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_LOCATIONBAR, FbLocationbarClass))

typedef struct _FbLocationbar	FbLocationbar;
typedef struct _FbLocationbarClass	FbLocationbarClass;

struct _FbLocationbar
{
	GtkHBox parent;

	GtkWidget *entry;
};

struct _FbLocationbarClass
{
	GtkHBoxClass parent_class;

	void (*location_activate) (FbLocationbar *lb,
				   gchar         *path);

};

GType             fb_locationbar_get_type      (void);

GtkWidget        *fb_locationbar_new           (void);

void              fb_locationbar_set_text      (FbLocationbar *lb,
						const gchar   *text);

#endif /* __FB_LOCATIONBAR_H__ */
