/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_IMAGE_H__
#define __FB_IMAGE_H__

enum {
	RIGHT_OPEN,
	LEFT_OPEN
};

#define FB_TYPE_IMAGE		 (fb_image_get_type ())
#define FB_IMAGE(obj)		 (G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_IMAGE, FbImage))
#define FB_IMAGE_CLASS(klass)	 (G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_IMAGE, FbImageClass))
#define FB_IS_IMAGE(obj)	 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_IMAGE))
#define FB_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_IMAGE))
#define FB_IMAGE_GET_CLASS(obj)	 (G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_IMAGE, FbImageClass))

typedef struct _FbTile FbTile;
typedef struct _FbImage FbImage;
typedef struct _FbImageClass FbImageClass;

struct _FbImage
{
	GtkWidget parent;

	GList *tiles;
	gint nth_tile;

	gboolean magnifying;
	gint magnify_w, magnify_h;
	gfloat magnify_power;
	GdkPixbuf *magnify_pixbuf;
	GdkRectangle *prev_magnify_area;

	gboolean open_way;

	gint timer_id;
	gint cursor_timer_id;
	gboolean cursor_move;
	gboolean is_enter;

	gint pointer_last_x;
	gint pointer_last_y;

	gchar *drag_data;
};

struct _FbImageClass
{
	GtkWidgetClass parent_class;
};

GType      fb_image_get_type            (void);

GtkWidget *fb_image_new                 (void);

gint       fb_image_get_n_images        (FbImage     *image);

void       fb_image_add_image           (FbImage     *image,
					 const gchar *path,
					 GtkOrientation way);

void       fb_image_remove_image        (FbImage     *image);

void       fb_image_set_file            (FbImage     *image,
					 const gchar *path);

gint       fb_image_set_file_at_pointer (FbImage     *image,
					 const gchar *path);

gchar     *fb_image_get_file_at_pointer (FbImage     *image);

void       fb_image_zoom                (FbImage     *image,
					 gfloat       ratio);

void       fb_image_zoom_at_value       (FbImage     *image,
					 gfloat       value);

void       fb_image_fit_window          (FbImage     *image);

void       fb_image_rotate              (FbImage     *image,
					 gboolean     counter_clockwise);

void       fb_image_mirror              (FbImage     *image,
					 gboolean     mirror,
					 gboolean     flip);

void       fb_image_get_first_image_pos (FbImage     *image,
					 gint        *x,
					 gint        *y);

void       fb_image_get_last_image_pos  (FbImage     *image,
					 gint        *x,
					 gint        *y);

#endif /* __FB_IMAGE_H__ */
