/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FB_DIRVIEW_H__
#define __FB_DIRVIEW_H__

#define FB_TYPE_DIRVIEW			(fb_dirview_get_type ())
#define FB_DIRVIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), FB_TYPE_DIRVIEW, FbDirview))
#define FB_DIRVIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), FB_TYPE_DIRVIEW, FbDirviewClass))
#define FB_IS_DIRVIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), FB_TYPE_DIRVIEW))
#define FB_IS_DIRVIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), FB_TYPE_DIRVIEW))
#define FB_DIRVIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), FB_TYPE_DIRVIEW, FbDirviewClass))

typedef enum {
	COLUMN_TYPE,           /* file type (gint)*/
	COLUMN_PATH,           /* file absolute path (gchar)*/
	COLUMN_SIZE,           /* file size (gint)*/
	COLUMN_MTIME,          /* file mtime (glong)*/
	COLUMN_READABLE,       /* file readable (gboolean) */
	COLUMN_ICON,           /* stock icon id (gchar)*/
	COLUMN_ICON_SIZE,      /* stock icon size (gint)*/
	COLUMN_DISPLAY_PATH,   /* (gchar) */
	COLUMN_PERMISSION,     /* permisson (gchar) */
	COLUMN_OWNER,          /* owner (gchar) */
	COLUMN_GROUP,          /* group (gchar) */
	COLUMN_DISPLAY_SIZE,   /* (gchar) */
	COLUMN_DISPLAY_MTIME,  /* (gchar) */
	COLUMN_EDITABLE,       /* row editable (gboolean) */
	NUM_COLUMNS
}FbDirColumn;

typedef struct _FbDirview	FbDirview;
typedef struct _FbDirviewClass	FbDirviewClass;

struct _FbDirview
{
	GtkTreeView parent;

	GtkTreeViewColumn *column;
	GtkTreeViewColumn *column1;
	GtkTreeViewColumn *column2;
	GtkTreeViewColumn *column3;
	GtkTreeViewColumn *column4;
	GtkTreeViewColumn *column5;

	GtkListStore *store;

	GtkWidget *next_history;
	GtkWidget *prev_history;
	GtkWidget *current;

	gchar *workdir;
	gboolean writable;
	gint image_num;
	gint source_id;

	gboolean dot_filter;
	gboolean other_filter;

	GtkTreePath *prev_path;
};

struct _FbDirviewClass
{
	GtkTreeViewClass parent_class;

	void (*path_activated) (FbDirview *dv,
				gchar     *path,
				gint       type);

	void (*path_setted)    (FbDirview *dv);

	void (*history_move)   (FbDirview *dv,
				gchar     *path);

};

GType             fb_dirview_get_type        (void);

GtkWidget        *fb_dirview_new             (void);

GList            *fb_dirview_get_path_list   (FbDirview   *dv,
					      FbFileType   type);

gboolean          fb_dirview_row_get         (FbDirview   *dv,
					      ...);

void              fb_dirview_row_remove      (FbDirview   *dv);

void              fb_dirview_row_edit        (FbDirview   *dv);

G_CONST_RETURN gchar *fb_dirview_get_workdir     (FbDirview   *dv);

void              fb_dirview_add_path        (FbDirview   *dv,
					      const gchar *path);

void              fb_dirview_add_new_dir     (FbDirview   *dv);

gboolean          fb_dirview_set_dir         (FbDirview   *dv,
					      const gchar *path);

void              fb_dirview_update_dir      (FbDirview   *dv);

void              fb_dirview_set_dotfilter   (FbDirview   *dv,
					      gboolean     set_filter);
  
void              fb_dirview_set_otherfilter (FbDirview   *dv,
					      gboolean     set_filter);

gboolean          fb_dirview_get_dotfilter   (FbDirview   *dv);
  
gboolean          fb_dirview_get_otherfilter (FbDirview   *dv);
  
void              fb_dirview_set_sort_mode   (FbDirview   *dv,
					      FbSortMode   mode);

void              fb_dirview_next_history    (FbDirview *dv);

void              fb_dirview_prev_history    (FbDirview *dv);

void              fb_dirview_clear_history   (FbDirview *dv);

/* utils func */
gchar            *replace_string             (const gchar *src_path,
					      const gchar *pattern,
					      const gchar *replace);

#endif /* __FB_DIRVIEW_H__ */
