/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "futaba.h"
#include "prefs.h"
#include "prefs-general.h"

typedef struct _FbPrefsGeneral
{
	GtkWidget *home_button;
	GtkWidget *location_entry;

	gboolean changed;
} FbPrefsGeneral;

static void cb_button_monitor(GtkButton *button, gpointer data);
static void cb_entry_monitor(GtkWidget *wg, GdkEventKey *event, gpointer data);
static void prefs_general_apply(void);
static void prefs_general_destroy(void);

static FbPrefsFunc prefs_func =
{
	apply: prefs_general_apply,
	destroy: prefs_general_destroy,
};

static FbPrefsGeneral *prefs_ui;

static void
cb_button_monitor(GtkButton *button,
		  gpointer data)
{
	prefs_ui->changed = TRUE;
}

static void
cb_entry_monitor(GtkWidget *wg,
	       GdkEventKey *event,
	       gpointer data)
{
	prefs_ui->changed = TRUE;
}

GtkWidget *
prefs_general_new(void)
{
	GSList *group;
	GtkWidget *main_vbox, *hbox, *table, *frame, *align;
	GtkWidget *button1, *button2;
	GtkWidget *entry, *label;

	prefs_ui = g_new0(FbPrefsGeneral, 1);

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);

	frame = gtk_frame_new(_("Start page"));
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	table = gtk_table_new(4, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("This is directory displayed at first"));
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label,
			 0, 2, 0, 1,
			 GTK_FILL, 0,
			 5, 0);
	gtk_widget_show(label);

	button1 = gtk_radio_button_new_with_label(NULL, _("Last Visited Location"));
	g_signal_connect(G_OBJECT(button1), "clicked",
			 G_CALLBACK(cb_button_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), button1,
			 0, 2, 1, 2,
			 GTK_FILL, 0,
			 5, 0);
	gtk_widget_show(button1);

	group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(button1));

	button2 = gtk_radio_button_new_with_label(group, _("Home Location"));
	g_signal_connect(G_OBJECT(button1), "clicked",
			 G_CALLBACK(cb_button_monitor), NULL);
	gtk_table_attach(GTK_TABLE(table), button2,
			 0, 2, 2, 3,
			 GTK_FILL, 0,
			 5, 0);
	gtk_widget_show(button2);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button2), home_start);

	frame = gtk_frame_new(_("Enter Home Location"));
	gtk_table_attach(GTK_TABLE(table), frame,
			 0, 2, 3, 4,
			 GTK_FILL | GTK_EXPAND, 0,
			 2, 2);
	gtk_widget_show(frame);

	align = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
	gtk_alignment_set_padding(GTK_ALIGNMENT(align), 0, 2, 2, 2);
	gtk_container_add(GTK_CONTAINER(frame), align);
	gtk_widget_show(align);

	entry = gtk_entry_new();
	if (home_page) gtk_entry_set_text(GTK_ENTRY(entry), home_page);
	g_signal_connect(G_OBJECT(entry), "key-release-event",
			 G_CALLBACK(cb_entry_monitor), NULL);
	gtk_container_add(GTK_CONTAINER(align), entry);
	gtk_widget_show(entry);

	prefs_ui->home_button = button2;
	prefs_ui->location_entry = entry;
	prefs_ui->changed = FALSE;

	return main_vbox;
}

FbPrefsFunc *
prefs_general_get_func(void)
{
	return &prefs_func;
}

static void
prefs_general_apply(void)
{
	if (!prefs_ui->changed) return;

	home_start = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_ui->home_button));

	if (home_page) g_free(home_page);
	home_page = g_strdup(gtk_entry_get_text(GTK_ENTRY(prefs_ui->location_entry)));

	prefs_ui->changed = FALSE;
}

static void
prefs_general_destroy(void)
{
	g_free(prefs_ui);
}
