/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IMAGEVIEWER_H__
#define __IMAGEVIEWER_H__

typedef enum {
	WINDOW_NORMAL = 1 << 0,
	WINDOW_MAX = 1 << 1,
	WINDOW_FULL = 1 << 2
} FbWindowSize;

enum {
	RIGHT,
	LEFT
};

typedef struct _FbImageCanvas FbImageCanvas;
typedef struct _FbImageViewer FbImageViewer;

struct _FbImageCanvas
{
	GtkWidget *widget;
	GdkPixmap *pixmap;
	GdkPixmap *zoom;
	GdkPixbuf *pixbuf;

	GdkRectangle *canvas;

	gchar *path;

	gint raw_width;
	gint raw_height;

	gfloat scale;

	gint x0;
	gint y0;

	gboolean fitting;
};

struct _FbImageViewer
{
	GtkWidget *top;
	GtkWidget *frame;
	GtkWidget *draw;
	GtkWidget *popup1;
	GtkWidget *popup2;

	FbImageCanvas *first;
	FbImageCanvas *second;
	GList *path_list;
	gint position;

	gint width;
	gint height;

	gint pointer_last_x;
	gint pointer_last_y;

	guint timer_id;

	guint size;
	gboolean two_pages;
	gint open_way;
	gboolean forward;
	gboolean zooming;
};

extern FbImageViewer *focus_viewer;

void fb_imageviewer_start(GList *path_list, gint n);
void fb_imageviewer_destroy(FbImageViewer *viewer);
void fb_imageviewer_next_pages(FbImageViewer *viewer, gint n);
void fb_imageviewer_prev_pages(FbImageViewer *viewer, gint n);
void fb_imageviewer_first_page(FbImageViewer *viewer);
void fb_imageviewer_last_page(FbImageViewer *viewer);
void fb_imageviewer_split_window(FbImageViewer *viewer);
void fb_imageviewer_fixup_window(FbImageViewer *viewer);

#endif /* __IMAGEVIEWER_H__ */
