/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FUTABA_H__
#define __FUTABA_H__

#include "intl.h"

#define FUTABA_RC_DIR "/.futaba"
#define FUTABA_EXTRACT_DIR FUTABA_RC_DIR"/tmp"
#define RC_FILE "/futabarc"
#define BOOKMARK_FILE "/bookmarks"
#define ACCEL_FILE "/keyaccelrc"

typedef struct _FbPreView FbPreView;
typedef struct _FbDirHistory FbDirHistory;
typedef struct _Futaba Futaba;

struct _FbPreView
{
	GtkWidget *box;
	GtkWidget *frame;
	GtkWidget *image;
	GtkWidget *label;

	gchar *path;

	gint width;
	gint height;

	gint raw_width;
	gint raw_height;
};

struct _FbDirHistory
{
	GtkWidget *prev;
	GtkWidget *next;
	GList *record;
	gint position;
	gint length;
};

struct _Futaba
{
	GtkWidget *top;
	GtkWidget *tool_bar;
	GtkWidget *location_bar;
	GtkWidget *entry;
	GtkWidget *status_bar;

	GtkUIManager *ui_manager;

	GtkWidget *treeview;
	GtkListStore *liststore;
	GtkTreeViewColumn *column1;
	GtkTreeViewColumn *column2;
	GtkTreeViewColumn *column3;
	GtkTreeViewColumn *column4;
	GtkTreeViewColumn *column5;
	gboolean dot_filter;
	gboolean other_filter;

	FbPreView *preview;
	gboolean show_preview;

	FbDirHistory *history;

	GList *bookmarks;

	gchar *workdir;
	gboolean writable;
	gint image_num; 

	gchar *extract_dir;

	gchar *paste_path;
	gboolean is_copy;

	gint width;
	gint height;

};
/* option */
extern gint futaba_width;
extern gint futaba_height;

extern gboolean home_start;
extern gchar *home_page;
extern gchar *last_page;

extern gint viewer_width;
extern gint viewer_height;
extern gint zoom_width;
extern gint zoom_height;
extern gfloat zoom_scale;
extern gint open_way;

extern gboolean cdir_filter;
extern gboolean pdir_filter;

extern gint thumbwin_width;
extern gint thumbwin_height;

extern gboolean show_coltitle;
extern gboolean show_col1;
extern gboolean show_col2;
extern gboolean show_col3;
extern gboolean show_col4;
extern gboolean show_col5;
extern gint sort_mode;
extern GtkSortType sort_direction;

/* function */
Futaba *futaba_new(void);
void futaba_quit(Futaba *futaba);

#endif /* __FUTABA_H__ */
