# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os.path
from glob import glob
import imp
import traceback
import itertools

import config
from board_plugin_base import BoardPluginBase

base_path = os.path.join(config.get_config_dir_path(), "scripts")
version = (0, 2)

def generate_board_plugin():
    plugin_list = []
    for module_path in glob(os.path.join(base_path, "board_*.py")):
        module_name, ext = os.path.splitext(os.path.basename(module_path))
        try:
            try:
                file, filename, description = imp.find_module(
                    module_name, [base_path])
                module = imp.load_module(
                    module_name, file, filename, description)
            finally:
                if file:
                    file.close()
        except ImportError:
            traceback.print_exc()
        else:
            yield module

def check_compatible(plugin_version):
    if version[0] > plugin_version[0]:
        return False
    elif version[0] < plugin_version[0]:
        return True
    else:
        return version[1] <= plugin_version[1]

def load_plugin(plugin_module, widget_tree):
    try:
        if check_compatible(plugin_module.version):
            klass = plugin_module.BoardPlugin
            if issubclass(klass, BoardPluginBase):
                klass(widget_tree)
            else:
                print klass, "is not subclass of BoardPluginBase"
        else:
            print plugin_module.__file__, "not compatible", \
                  plugin_module.version
    except:
        traceback.print_exc()
    
def load(widget_tree):
    for i in itertools.imap(lambda e: load_plugin(e, widget_tree),
                            generate_board_plugin()): -1
