# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk
import gobject
import time


class BaseTreeViewColumn(gtk.TreeViewColumn):
    min_width = 20

    def __init__(self, renderer, treeview):
        gtk.TreeViewColumn.__init__(self, self.label, renderer)
        self.treeview = treeview
        self.setup()

    def setup(self):
        self.set_resizable(True)
        self.set_reorderable(True)
        self.set_clickable(True)
        self.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        self.set_min_width(self.min_width)
        self.set_fixed_width(self.def_width)

        renderers = self.get_cell_renderers()
        self.set_cell_data_func(renderers[0], self.on_cell_data)

        self.connect("clicked", self.on_column_clicked)
        self.treeview.append_column(self)

    def on_sort_column_changed(self):
        model = self.treeview.get_model()
        if model:
            sort_column_name, sort_reverse = model.get_sort()
            if sort_column_name != self.id:
                self.set_sort_indicator(False)
            else:
                self.set_sort_indicator(True)
                if sort_reverse:
                    self.set_sort_order(gtk.SORT_DESCENDING)
                else:
                    self.set_sort_order(gtk.SORT_ASCENDING)
        
    def on_column_clicked(self, treeviewcolumn):
        model = self.treeview.get_model()
        if model:
            model.sort(self.id)
            for column in self.treeview.get_columns():
                column.on_sort_column_changed()

    def on_cell_data(self, column, cell, model, iter):
        self.updated_thread_highlight(column, cell, model, iter)

        value = model.get_dict(iter)[self.name]
        if type(value) in (int, float):
            if value == 0:
                cell.set_property("text", "")
            else:
                cell.set_property("text", str(value))
        else:
            cell.set_property("text", value)

    def updated_thread_highlight(self, column, cell, model, iter):

        def is_updated_thread():
            res = model.get_dict(iter)["res"]
            linecount = model.get_dict(iter)["lineCount"]
            return res != 0 and linecount != 0 and res > linecount

        if is_updated_thread():
            cell.set_property("weight", 800)
        else:
            cell.set_property("weight", 400)


tree_view_column_list = []
    
class TreeViewColumn_Number(BaseTreeViewColumn):
    name = "num"
    id = "num"
    label = "No."
    def_width = 30

    def on_sort_column_changed(self):
        model = self.treeview.get_model()
        if model:
            sort_column_name, sort_reverse = model.get_sort()
            if sort_column_name == self.id and sort_reverse:
                self.set_sort_indicator(True)
                self.set_sort_order(gtk.SORT_DESCENDING)
            else:
                self.set_sort_indicator(False)
        
tree_view_column_list.append(TreeViewColumn_Number)


class TreeViewColumn_Title(BaseTreeViewColumn):
    name = "title"
    id = "title"
    label = "Title"
    def_width = 330

tree_view_column_list.append(TreeViewColumn_Title)


class TreeViewColumn_Res(BaseTreeViewColumn):
    name = "res"
    id = "res"
    label = "Res"
    def_width = 50

tree_view_column_list.append(TreeViewColumn_Res)


class TreeViewColumn_LineCount(BaseTreeViewColumn):
    name = "lineCount"
    id = "lineCount"
    label = "Read"
    def_width = 50

tree_view_column_list.append(TreeViewColumn_LineCount)


class TreeViewColumn_LastModified(BaseTreeViewColumn):
    id = "lastModified"
    label = "Last Modified"
    def_width = 200

    def on_cell_data(self, column, cell, model, iter):
        self.updated_thread_highlight(column, cell, model, iter)

        lastmod = model.get_dict(iter)["lastModified"]
        if lastmod == 0:
            cell.set_property("text", "")
        else:
            cell.set_property("text", time.strftime(
                "%Y/%m/%d(%a) %H:%M:%S", time.localtime(lastmod)))

tree_view_column_list.append(TreeViewColumn_LastModified)


class TreeViewColumn_Average(BaseTreeViewColumn):
    name = "average"
    id = "average"
    label = "Average"
    def_width = 50

tree_view_column_list.append(TreeViewColumn_Average)
