# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


class BookmarkFormatError(Exception):

    def __init__(self, value):
        self.value = value

    def __str__(self):
        return self.value


class BaseBookmark(object):

    def __init__(self, uri, name, *categories):
        self.uri = uri
        self.name = name
        self.categories = [cat for cat in categories]


class Bookmark(BaseBookmark):

    def __init__(self, uri=None, name=None, categories=None, formatted=None):
        if uri and name:
            pass
        elif formatted:
            uri, name, categories = self._parse_text(formatted)
        else:
            assert(False), "uri and name, or formatted must be set"
        if not uri:
            raise BookmarkFormatError, "uri must not be empty"
        if not name:
            raise BookmarkFormatError, "name must not be empty"
        super(Bookmark, self).__init__(uri, name, *categories)

    def _parse_text(self, formatted):
        formatted = formatted.rstrip("\n")
        datalist = formatted.split("\t")

        name = None
        uri = None
        categories = []

        for keyvalue in datalist:
            if keyvalue.startswith("name="):
                name = keyvalue[len("name="):]
            elif keyvalue.startswith("uri="):
                uri = keyvalue[len("uri="):]
            elif keyvalue.startswith("category="):
                category = keyvalue[len("category="):]
                if category and category not in categories:
                    categories.append(category)

        return uri, name, categories

    def tabbed_text(self):
        def append_tab(text):
            if text:
                text += "\t"
            return text

        text = ""
        if self.name:
            text = append_tab(text)
            text += "name=%s" % self.name
        if self.uri:
            text = append_tab(text)
            text += "uri=%s" % self.uri
        for category in self.categories:
            if category:
                text = append_tab(text)
                text += "category=%s" % category
        return text
