# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gobject
import codecs
import urllib
import urllib2
import cookielib
import os.path
import sys

from BbsType import bbs_type_judge_uri
from BbsType import bbs_type_exception
from HTMLParserEx import HTMLParserEx
import datfile
import uri_opener
import config
from http_sub import HTTPDebugHandler

GLADE_FILENAME = "submit_window.glade"

cookie_jar = cookielib.CookieJar()
opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cookie_jar),
                              HTTPDebugHandler)

def open(uri):
    if not uri:
        raise ValueError, "parameter must not be empty"

    WinWrap(uri)


class ConfirmationHTMLParser(HTMLParserEx):

    def __init__(self):
        HTMLParserEx.__init__(self)
        self.message = ""
        self.inputs = []
        self.complete = False
        self.title = ""
        self.in_head = False
        self.in_title = False

    def handle_starttag(self, tag, attr):
        if tag == "br":
            self.message += "\n"
        elif tag == "input":
            self.inputs.append(dict(attr))
        elif tag == "title":
            self.in_title = True
        elif tag == "head":
            self.in_head = True
        elif tag == "meta":
            attr_dict = dict(attr)
            if "http-equiv" in attr_dict \
               and attr_dict["http-equiv"] == "refresh":
                self.complete = True

    def handle_endtag(self, tag):
        if tag == "title":
            self.in_title = False
        elif tag == "head":
            self.in_head = False

    def handle_comment(self, comment):
        pass

    def handle_data(self, data):
        if self.in_title:
            self.title = data
        elif not self.in_head:
            self.message += data.rstrip()

    def handle_charref(self, ref):
        data = None
        try:
            data = unichr(int(ref))
        except:
            data = "&#"+ref+";"
        self.message += data

    def handle_entityref(self, name):
        if name in htmlentitydefs.name2codepoint:
            codepoint = htmlentitydefs.name2codepoint[name]
            self.message += unichr(codepoint)
        else:
            self.message += "&"+name+";"


class WinWrap:

    def __init__(self, uri):
        self.uri = uri
        self.bbs_type = bbs_type_judge_uri.get_type(uri)
        if not self.bbs_type.is_thread():
            raise bbs_type_exception.BbsTypeError, \
                  "the uri does not represent thread: " + uri

        glade_path = os.path.join(config.glade_dir, GLADE_FILENAME)
        self.widget_tree = gtk.glade.XML(glade_path)
        self.window = self.widget_tree.get_widget("submit_window")
        self.entry_name = self.widget_tree.get_widget("entry_name")
        self.entry_mail = self.widget_tree.get_widget("entry_mail")
        self.textbuffer = self.widget_tree.get_widget("textview").get_buffer()

        sigdic = {"on_submit_activate": self.on_submit_activate,
                  "on_close_activate": self.on_close_activate}

        self.widget_tree.signal_autoconnect(sigdic)

        title = datfile.get_title_from_dat(self.bbs_type)
        if title:
            self.window.set_title(title)

    def on_close_activate(self, widget):
        self.window.destroy()

    def on_submit_activate(self, widget):
        name = self.entry_name.get_text()
        mail = self.entry_mail.get_text()
        msg = self.textbuffer.get_text(
            self.textbuffer.get_start_iter(), self.textbuffer.get_end_iter())

        self.post_dict = self.bbs_type.build_post_dict(name, mail, msg)
        self.post_dict = self.bbs_type.set_extra_post(self.post_dict)

        self.do_submit()

    def do_submit(self):
        for name, value in self.post_dict.iteritems():
            print "%s: %s" \
                  % (name, value.decode(self.bbs_type.encoding, "replace"))
        post_encoded = urllib.urlencode(self.post_dict)

        req = urllib2.Request(self.bbs_type.get_post_uri(), post_encoded)
        req.add_header("Referer", self.uri)
        req.add_header("User-agent", config.User_Agent)

        res = opener.open(req)
        self.on_response(res)

    def on_response(self, response):
        data = response.read()
        info = response.info()
        if "Content-Type" in info:
            import re
            match = re.search(
                "charset=(?P<charset>[a-zA-Z0-9_\-]+)", info["Content-Type"])
            if match:
                charset = match.group("charset").lower()

        if charset in ("x-sjis", "x_sjis", "sjis", "shiftjis", "shift-jis",
                       "shift_jis", "s-jis", "s_jis"):
            encoding = "cp932"
        elif charset in ("euc-jp", "euc_jp", "eucjp"):
            encoding = "euc-jp"

        if encoding:
            data = data.decode(encoding, "replace")
        p = ConfirmationHTMLParser()
        p.feed(data)
        p.close()

        print data

        window = gtk.Window()
        if not p.complete:
            window.set_default_size(500, 500)
        if p.title:
            window.set_title(p.title)
        textview = gtk.TextView()
        textview.set_wrap_mode(gtk.WRAP_CHAR)
        textview.set_editable(False)
        buf = textview.get_buffer()
        buf.insert(buf.get_end_iter(), p.message)

        for input in p.inputs:
            if "type" in input and input["type"] == "submit":
                button = gtk.Button(input["value"])
                button.connect("clicked",
                               lambda widget: self.on_button_submit_clicked(
                    widget, p.inputs, encoding))
                anchor = buf.create_child_anchor(buf.get_end_iter())
                textview.add_child_at_anchor(button, anchor)
                button.grab_focus()
                break

        window.add(textview)
        window.show_all()

        if p.complete:

            def on_timeout(widget):
                widget.destroy()
                uri_opener.open_uri(self.bbs_type.get_thread_uri(), True)

            gobject.timeout_add(2 * 1000, on_timeout, window)

    def on_button_submit_clicked(self, widget, inputs, encoding):
        widget.get_toplevel().destroy()
        self.post_dict = {}
        for input in inputs:
            if "name" in input and "value" in input:
                name = input["name"]
                value = input["value"]
                if encoding:
                    value = value.encode(encoding, "replace")
                self.post_dict[name] = value

        self.do_submit()
