# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk
import gobject
import gconf
import traceback

import uri_opener
from BbsType import bbs_type_judge_uri
from BbsType import bbs_type_exception
import config

# key: /bbs/board/thread value: toplevel window widget
_windows = {}

def get_window(key):
    if key in _windows:
        return _windows[key]
    else:
        return None

def regist(winwrap):
    if not winwrap:
        raise ValueError, "parameter must not be empty"

    key = winwrap.get_uri()
    if not key:
        raise ValueError, "uri must not be empty"

    if key in _windows:
        return False

    _windows[key] = winwrap
    print "regist to _windows", key
    return True

def unregist(winwrap):
    key = winwrap.get_uri()
    if key not in _windows:
        print key, "is not found in _windows"
        return

    del _windows[key]
    print "unregist from _windows", key

    if not _windows:
        print "all window unregist"
        on_all_window_destroy()

def on_all_window_destroy():
    gtk.main_quit()

def thread_idx_updated(thread_uri, idx_dic):
    if not thread_uri or not idx_dic:
        raise ValueError, "parameter must not be empty"

    gobject.idle_add(on_thread_idx_updated, thread_uri, idx_dic)

def on_thread_idx_updated(thread_uri, idx_dic):
    bbs_type = bbs_type_judge_uri.get_type(thread_uri)
    winwrap = get_window(bbs_type.get_uri_base())
    if winwrap:
        winwrap.on_thread_idx_updated(thread_uri, idx_dic)

def main_quit():
    print "session main quit"

    uris = _windows.keys()
    try:
        gconf_client = gconf.client_get_default()
        gconf_key_windows = config.gconf_app_key_base() + "/windows"
        if uris:
            gconf_client.set_list(
                gconf_key_windows, gconf.VALUE_STRING, uris)
            print "save windows", uris
        else:
            gconf_client.unset(gconf_key_windows)
            print "save no window"
    except:
        pass

    temp = dict(_windows)
    for uri, winwrap in temp.iteritems():
        try:
            winwrap.destroy()
        except:
            traceback.print_exc()

    # not reach here.
    gtk.main_quit()

def restore():
    gconf_client = gconf.client_get_default()

    gconf_key_windows = config.gconf_app_key_base() + "/windows"
    uris = gconf_client.get_list(gconf_key_windows, gconf.VALUE_STRING)
    for uri in uris:
        try:
            uri_opener.open_uri(uri)
        except bbs_type_exception.BbsTypeError, msg:
            print msg

def start():
    restore()
    if not _windows:
        uri_opener.open_uri("http://ex11.2ch.net/morningcoffee/")
    gtk.main()    
