# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import gobject
import os.path
import glob
import codecs
import urllib2
import traceback
import itertools

import cachefile
import idxfile
import misc
import config
from http_sub import HTTPRedirectHandler302, HTTPDebugHandler

BOARD_DATA_INVALID_VALUE = 0


class BoardData:

    def __init__(self, bbs_type):
        self.bbs_type = bbs_type

    def set_status(self, text):
        pass

    def _merge_new_thread(self, datalist, id, title, res, num, lastmod):
        average = 0
        if lastmod != 0:
            try:
                start = int(id)
            except ValueError:
                pass
            else:
                # avoid the Last-Modified time of subject.txt and
                # the build time of thread is equal (zero division)
                dur = lastmod - start
                if dur == 0:
                    average = 999999
                else:
                    average = round(res * 60 * 60 * 24.0 / dur, 2)

        if id in datalist:
            item = datalist[id]
            if item["num"]:
                # already exists in datalist and num is not 0, then this thread
                # is duplicate in subject.txt.
                # ignore second.
                pass
            else:
                item["num"] = num
                item["title"] = title
                item["res"] = res
                item["average"] = average
        else:
            datalist[id] = {"num": num, "title": title,
                            "res": res, "lineCount": BOARD_DATA_INVALID_VALUE,
                            "lastModified": "", "average": average}

    def merge_local_subjecttxt(self, datalist):
        f = lambda id, title, res, num, lastmod: \
            self._merge_new_thread(datalist, id, title, res, num, lastmod)
        self._load_subjecttxt(f)

    def merge_remote_subjecttxt(self, datalist):
        f = lambda id, title, res, num, lastmod: \
            self._merge_new_thread(datalist, id, title, res, num, lastmod)
        self._get_subjecttxt(f)

    def _add_idx(self, datalist, id, dic):
        datalist[id] = dic
        dic["num"] = 0
        dic["res"] = 0
        dic["average"] = 0
        
    def load_idxfiles(self):
        datalist = {}

        def on_load_record(id, metadata_dic):
            bbs_type_for_thread = self.bbs_type.clone_with_thread(id)
            idxfile_path = misc.get_thread_idx_path(bbs_type_for_thread)
            if os.path.exists(idxfile_path):
                self._add_idx(datalist, id, metadata_dic)

        print "load_cache"
        cachefile.load_cache(self.bbs_type, on_load_record)
        print "load_idx"
        self._load_modified_idxfiles(datalist)
        print "save_cache"
        cachefile.save_cache(self.bbs_type, datalist)

        return datalist

    def _load_modified_idxfiles(self, datalist):
        basedir = misc.get_thread_idx_dir_path(self.bbs_type)
        if os.path.isdir(basedir):
            for idxfile_path in glob.glob(os.path.join(basedir, "*.idx")):
                thread_id, ext = os.path.splitext(
                    os.path.basename(idxfile_path))
                idxlastModified = os.path.getmtime(idxfile_path)
                bbs_type_for_thread = self.bbs_type.clone_with_thread(
                    thread_id)
                if thread_id not in datalist:
                    print "new"
                    dic = idxfile.load_idx(bbs_type_for_thread)
                    #dic.pop("etag")
                    dic["idxlastModified"] = idxlastModified
                    self._add_idx(datalist, thread_id, dic)
                elif idxlastModified > datalist[thread_id]["idxlastModified"]:
                    print "modified"
                    datalist[thread_id]["idxlastModified"] = idxlastModified
                    dic = idxfile.load_idx(bbs_type_for_thread)
                    for name in idxfile.metadata_namelist:
                        datalist[thread_id][name] = dic[name]

    def _split_record(self, line_encoded):
        line = line_encoded.decode(self.bbs_type.encoding, "replace")
        m = self.bbs_type.subject_reg.match(line)
        if m:
            id = m.group("id")
            title = m.group("title")
            try:
                res = int(m.group("res"))
            except ValueError:
                res = 0
            return id, title, res
        return None

    def _load_subjecttxt(self, func):
        lastmod = self.load_board_idx()
        try:
            lastmod = misc.httpdate_to_secs(lastmod)
        except ValueError:
            lastmod = 0

        subjecttxt_path = misc.get_board_subjecttxt_path(self.bbs_type)
        try:
            for num, line_encoded \
                    in itertools.izip(itertools.count(1),
                                      file(subjecttxt_path)):
                result = self._split_record(line_encoded)
                if result:
                    id, title, res = result
                    try:
                        func(id, title, res, num, lastmod)
                    except:
                        traceback.print_exc()
        except IOError:
            traceback.print_exc()

    def _get_subjecttxt(self, func):

        # get subject.txt

        opener = urllib2.build_opener(HTTPRedirectHandler302, HTTPDebugHandler)
        request = urllib2.Request(self.bbs_type.get_subject_txt_uri())
        request.add_header("User-agent", config.User_Agent)
        try:
            response = opener.open(request)
        except urllib2.HTTPError, e:
            gobject.idle_add(self.set_status, "%d %s" % (e.code, e.msg))
            print "switch to local"
            self._load_subjecttxt(func)
        except urllib2.URLError, e:
            print e
            gobject.idle_add(self.set_status, str(e))
            print "switch to local"
            self._load_subjecttxt(func)
        else:
            status = "%d %s" % (response.code, response.msg)
            gobject.idle_add(self.set_status, status)
            info = response.info()

            lastmod = 0
            if "Last-Modified" in info:
                _lastmod = info["Last-Modified"]
                self.save_board_idx(_lastmod)
                try:
                    lastmod = misc.httpdate_to_secs(_lastmod)
                except ValueError:
                    lastmod = 0

            subjecttxt_path = misc.get_board_subjecttxt_path(self.bbs_type)
            basedir = os.path.dirname(subjecttxt_path)
            if not os.path.isdir(basedir):
                os.makedirs(basedir)
            f = None
            try:
                f = file(subjecttxt_path, "w")
            except IOError:
                traceback.print_exc()

            try:
                for num, line_encoded in itertools.izip(itertools.count(1),
                                                        response):
                    if f:
                        try:
                            f.write(line_encoded)
                        except IOError:
                            traceback.print_exc()
                    result = self._split_record(line_encoded)
                    if result:
                        id, title, res = result
                        try:
                            func(id, title, res, num, lastmod)
                        except:
                            traceback.print_exc()
            except:
                traceback.print_exc()

            if f:
                f.close()
                f = None

    def load_board_idx(self):
        lastmod = ""
        boardidxfile = misc.get_board_idx_path(self.bbs_type)
        try:
            for line in file(boardidxfile):
                if line.startswith("lastModified="):
                    lastmod = line[len("lastModified="):].rstrip("\n")
                    break
        except IOError:
            traceback.print_exc()
        return lastmod

    def save_board_idx(self, lastmod):
        if not lastmod:
            return

        boardidx_path = misc.get_board_idx_path(self.bbs_type)
        basedir = os.path.dirname(boardidx_path)
        if not os.path.isdir(basedir):
            os.makedirs(basedir)

        f = file(boardidx_path, "w")
        f.write("lastModified=" + lastmod + "\n")
        f.close()
