# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import re

from bbs_type_2ch import BaseType

_base_reg_expr = re.compile("http://(?P<host>yy\d{2}\.(?:kakiko\.com|60\.kg))/(?P<board>[^/]+)(?:/[^/]*){0,1}$")
_cgi_reg_expr = re.compile("http://(?P<host>yy\d{2}\.(?:kakiko\.com|60\.kg))/test/read.cgi/(?P<board>[^/]+)/(?P<thread>[^/]+)/.*")


class TypeYY(BaseType):
    bbs_type = "yy"
    _base_reg = _base_reg_expr
    _cgi_reg = _cgi_reg_expr
