# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import re
import codecs

from bbs_type_exception import BbsTypeError
from bbs_type_base import BaseType

# default name for morningcoffee
moco_name = u'\u540d\u7121\u3057\u52df\u96c6\u4e2d\u3002\u3002\u3002'

_base_reg_expr = re.compile("http://(?P<host>[^./]+\.2ch\.net)/(?P<board>[^/]+)(?:/[^/]*){0,1}$")
_cgi_reg_expr = re.compile("http://(?P<host>[^./]+\.2ch\.net)/test/read.cgi/(?P<board>[^/]+)/(?P<thread>[^/]+)/.*")


class Type2ch(BaseType):
    bbs_type = "2ch"
    _base_reg = _base_reg_expr
    _cgi_reg = _cgi_reg_expr

    def is_same_board(self, another):
        return self.bbs_type == another.bbs_type \
               and self.board == another.board

    def set_extra_post(self, post_dict):
        post_dict["hana"] = "mogera"

        if self.board == "morningcoffee":
            if "FROM" not in post_dict or not post_dict["FROM"]:
                post_dict["FROM"] = moco_name.encode("cp932", "replace")

        return post_dict

    def get_board_dir_path(self):
        """Returns board dir path from logs dir downward, not full path"""

        return self.bbs_type + "/" + self.board
