# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk


class ThreadListModel(gtk.GenericTreeModel):
    column_types = (str, int, str, int, int, int, float)
    column_names = ["id", "num", "title", "res", "lineCount",
                    "lastModified", "average"]
    column_width = [0, 30, 330, 50, 50, 200, 50]

    def __init__(self, list=None, sort_column_name="num", sort_reverse=False,
                 filter_func=None):
        gtk.GenericTreeModel.__init__(self)
        if list:
            self.original_list = list[:]
        else:
            self.original_list = []

        self.sort_column_name = sort_column_name
        self.sort_reverse = sort_reverse
        self.filter_func = filter_func

        self.do_filter()
        self.do_sort(self.sort_column_name, self.sort_reverse)

    def modify_row(self, dict):
        id = dict["id"]
        if id in self.order_dict:
            index = self.order_dict[id]
            target_dict = self.list[index]
            for name in self.column_names:
                if name in dict:
                    target_dict[name] = dict[name]
            self.row_changed(index, self.get_iter(index))

    def refilter(self):
        before_size = len(self.list)
        self.do_filter()
        after_size = len(self.list)
        self.do_sort(self.sort_column_name, self.sort_reverse)
        self.list_modified(before_size, after_size)
        
    def set_list(self, newlist):
        self.original_list = newlist[:]
        self.refilter()

    def set_filter_func(self, func):
        self.filter_func = func

    def build_order_dict(self):
        # key: thread id, value: index in self.list
        self.order_dict = dict(
            [(item["id"], index) for index, item in enumerate(self.list)])

    def list_modified(self, before_size, after_size):
        if before_size > after_size:
            print "remove", before_size-after_size, "threads"
            for i in range(before_size - after_size):
                self.row_deleted(after_size)
        elif after_size > before_size:
            print "insert", after_size-before_size, "threads"
            for i in range(before_size, after_size):
                self.row_inserted(i, self.get_iter(i))

    def do_filter(self):
        if not self.filter_func:
            self.list = self.original_list[:]
            return

        self.list = []
        for item in self.original_list:
            if self.filter_func(self, item):
                self.list.append(item)

    def compare(self, v1, v2, reverse):
        if not reverse:
            if v1 == 0 and v2 == 0:
                return 0
            elif v1 == 0:
                return 1
            elif v2 == 0:
                return -1
        if v1 > v2:
            return 1
        elif v1 < v2:
            return -1
        else:
            return 0

    def get_sort(self):
        return self.sort_column_name, self.sort_reverse

    def do_sort(self, column_name, reverse):
        if self.column_types[self.column_names.index(column_name)] == str:
            self.list.sort(None, lambda dic: dic[column_name], reverse)
        else:
            h = lambda x, y: self.compare(x, y, reverse)
            self.list.sort(h, lambda dic: dic[column_name], reverse)
        self.build_order_dict()

    def sort(self, column_name, order_specified=False, reverse=False):
        old_order_dict = self.order_dict

        if order_specified:
            self.sort_reverse = reverse
        else:
            if column_name == self.sort_column_name:
                # sort reverse
                self.sort_reverse = not self.sort_reverse
            else:
                self.sort_reverse = False
        self.sort_column_name = column_name

        self.do_sort(self.sort_column_name, self.sort_reverse)

        neworder = [old_order_dict[item["id"]] for item in self.list]
        self.rows_reordered(None, None, neworder)

    def on_get_flags(self):
        return gtk.TREE_MODEL_LIST_ONLY

    def on_get_n_columns(self):
        return len(self.column_types)

    def on_get_column_type(self, n):
        return self.column_types[n]

    def on_get_iter(self, path):
        try:
            return self.list[path[0]]
        except IndexError:
            return None

    def on_get_path(self, rowref):
        return self.order_dict[rowref["id"]]

    def on_get_value(self, rowref, column):
        return rowref[self.column_names[column]]

    def on_iter_next(self, rowref):
        try:
            i = self.order_dict[rowref["id"]] + 1
            return self.list[i]
        except IndexError:
            return None

    def on_iter_children(self, rowref):
        if rowref:
            return None
        return self.list[0]

    def on_iter_has_child(self, rowref):
        return False

    def on_iter_n_children(self, rowref):
        if rowref:
            return 0
        return len(self.list)

    def on_iter_nth_child(self, rowref, n):
        if rowref:
            return None
        try:
            return self.list[n]
        except IndexError:
            return None

    def on_iter_parent(self, child):
        return None
