# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
import os.path
from fileinput import FileInput
import misc

metadata_namelist = ["title", "lineCount", "lastModified", "etag"]

def load_idx(bbs_type):
    """Loads index file of thread

    bbs: bbs id

    board: board id

    thread: thread id

    return dictionary which key is in metadata_namelist if idx file exist,
    otherwise return empty dic
    """
    idxfile_path = misc.get_thread_idx_path(bbs_type)
    if not os.path.exists(idxfile_path):
        return {"title":"","lineCount":0,"lastModified":"","etag":""}

    datadic = {}
    f = FileInput(idxfile_path)
    for line in f:
        for name in metadata_namelist:
            if line.startswith(name+"="):
                value = line[len(name)+1:].rstrip("\n")
                if name is "lineCount":
                    try:
                        datadic[name] = int(value)
                    except:
                        datadic[name] = 0
                else:
                    datadic[name] = value
                #print name, datadic[name]
                break;
    f.close()

    # if datadic does not have key, insert empty entry.
    for name in metadata_namelist:
        if name not in datadic:
            if name is "lineCount":
                datadic[name] = 0
            else:
                datadic[name] = ""
    return datadic

def save_idx(bbs_type, datadic):
    """Saves thread metadatas to a index file

    bbs: bbs id

    board: board id

    thread: thread id

    datadic: dictionary which key is in metadata_namelist

    no need to save empty or non-existing metadata
    """

    # create a directory where idx file should belong if does not exist
    idxfile_path = misc.get_thread_idx_path(bbs_type)
    basedir = os.path.dirname(idxfile_path)
    if not os.path.isdir(basedir):
        os.makedirs(basedir)

    f = open(idxfile_path, "w")
    for name in metadata_namelist:
        if name in datadic:
            if name is "lineCount":
                if datadic[name] > 0:
                    f.write(name + "=" + str(datadic[name]) + "\n")
            else:
                if datadic[name]:
                    f.write(name + "=" + datadic[name] + "\n")
    f.close()
