# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os

import misc

metadata_namelist = ["title", "lineCount", "lastModified", "idxlastModified"]

def load_cache(bbs_type, func):
    """ Loads metadata from .cache file

    loads metadata and invokes handler per one thread

    bbs: bbs id

    board: board id

    func: invoked at loading one thread's metadata
    should be of the form:
    def handler_example(id, metadata_dic):
    where the first argument is thread id and
    the second metadata dic which key is in metadata_namelist
    """

    # nothing to do if .cache file does not exist
    cachefile_path = misc.get_board_cache_path(bbs_type)
    if not os.path.exists(cachefile_path):
        return

    f = open(cachefile_path, "r")
    try:
        line = f.readline()
        while line:
            metadatas = line.split("\t")
            dic = {}
            for field in metadatas:
                for name in ["id", "title", "lineCount",
                             "lastModified", "idxlastModified"]:
                    if field.startswith(name+"="):
                        value = field[len(name)+1:]
                        if name is "lineCount" or name is "idxlastModified":
                            try:
                                dic[name] = int(value)
                            except:
                                dic[name] = 0
                        else:
                            dic[name] = value
            # invoke func only if id exists
            if "id" in dic and dic["id"]:
                # if metadata in metadata_namelist does not exist,
                # set empty str or 0
                for name in metadata_namelist:
                    if name not in dic:
                        if name is "lineCount" or name is "idxlastModified":
                            dic[name] = 0
                        else:
                            dic[name] = ""
                func(dic["id"], dic)
            line = f.readline()
    finally:
        f.close()

def save_cache(bbs_type, dic):
    """ Saves metadata list to .cache file

    bbs: bbs id

    board: board id

    dic: dictionary of thread id and metadata dictionary
    which key is in metadata_namelist
    """
    # nothing to do if dic is empty
    if not dic:
        return

    cachefile_path = misc.get_board_cache_path(bbs_type)

    # create a directroy where .cache file is if not exists
    basedir = os.path.dirname(cachefile_path)
    if not os.path.isdir(basedir):
        os.makedirs(basedir)

    f = open(cachefile_path, "w")
    for id, metadata_list in dic.iteritems():
        # save only if id is not empty
        if id:
            line = "id=" + id + "\t"
            # save metadata only if exists in metadata_namelist
            for name in metadata_namelist:
                # save metadata only if exists in metadata_list
                # and no need to save an empty or invalid field
                if name in metadata_list:
                    if name is "lineCount" or name is "idxlastModified":
                        if metadata_list[name] > 0:
                            line += name + "=" + str(metadata_list[name]) + "\t"
                    else:
                        if metadata_list[name]:
                            line += name + "=" + metadata_list[name] + "\t"
            line += "\n"
            f.write(line)
    f.close()
