# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import os.path
import sys

from bookmark_core import Bookmark
import config

GLADE_FILENAME = "bookmark_editwindow.glade"


class BookmarkEditWindow:

    def __init__(self, on_newbookmark_complete, bookmark=None):
        glade_path = os.path.join(config.glade_dir, GLADE_FILENAME)
        self.widget_tree = gtk.glade.XML(glade_path)
        self.widget_tree.signal_autoconnect(self)
        self.window = self.widget_tree.get_widget("window_editbookmark")
        self.entry_name = self.widget_tree.get_widget("entry_name")
        self.entry_uri = self.widget_tree.get_widget("entry_uri")
        self.button_ok = self.widget_tree.get_widget("button_ok")
        self.button_cancel = self.widget_tree.get_widget("button_cancel")
        self.button_category_add = self.widget_tree.get_widget(
            "button_category_add")
        self.button_category_edit = self.widget_tree.get_widget(
            "button_category_edit")
        self.button_category_delete = self.widget_tree.get_widget(
            "button_category_delete")
        self.treeview_categories = self.widget_tree.get_widget(
            "treeview_categories")

        cell = gtk.CellRendererText()
        cell.set_property("editable", True)
        cell.connect("edited", self.on_cell_edited)
        treeviewcolumn = gtk.TreeViewColumn(None, cell, text=0)
        treeviewcolumn.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        self.treeview_categories.append_column(treeviewcolumn)
        self.treeview_categories.set_fixed_height_mode(True)
        self.treeview_categories.set_model(gtk.ListStore(str))

        self.on_newbookmark_complete = on_newbookmark_complete
        self.bookmark = bookmark
        if bookmark:
            self.entry_name.set_text(bookmark.name)
            self.entry_uri.set_text(bookmark.uri)
            model = self.treeview_categories.get_model()
            for category in bookmark.categories:
                model.append([category])

    def on_button_ok_clicked(self, widget):
        bookmark_name = self.entry_name.get_text()
        bookmark_uri = self.entry_uri.get_text()
        if not bookmark_name or not bookmark_uri:
            dialog = gtk.Dialog(
                "Confirmation", self.window,
                gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                (gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
            label = gtk.Label("NAME and URL must be set")
            dialog.vbox.pack_start(label, True, True, 0)
            label.show()
            dialog.run()
            dialog.destroy()
        else:
            bookmark_categories = []
            for row in self.treeview_categories.get_model():
                category = row.model.get_value(row.iter, 0)
                if category and category not in bookmark_categories:
                    bookmark_categories.append(category)
            bookmark = Bookmark(uri=bookmark_uri, name=bookmark_name,
                                categories=bookmark_categories)
            self.on_newbookmark_complete(bookmark)
            self.window.destroy()

    def on_button_cancel_clicked(self, widget):
        self.window.destroy()

    def on_button_category_add_clicked(self, widget):
        dialog = gtk.Dialog(
            "Input Category Name", self.window,
            gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
            (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
             gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        dialog.set_default_response(gtk.RESPONSE_ACCEPT)
        entry = gtk.Entry()
        entry.set_property("activates-default", True)
        dialog.vbox.pack_start(entry, True, True, 0)
        entry.show()
        response = dialog.run()
        if response == gtk.RESPONSE_ACCEPT:
            text = entry.get_text()
            model = self.treeview_categories.get_model()
            if model and text:
                model.append([text])
        dialog.destroy()

    def on_button_category_delete_clicked(self, widget):
        selection = self.treeview_categories.get_selection()
        model, iter = selection.get_selected()
        if iter:
            model.remove(iter)

    def on_cell_edited(self, cell, path, new_text):
        model = self.treeview_categories.get_model()
        if model:
            iter = model.get_iter(path)
            if iter:
                model.set_value(iter, 0, new_text)
