# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import re
import os.path
import traceback

from bbs_type_2ch import BaseType
from bbs_type_exception import BbsTypeError

_whitelist = []

whitelist_path = os.path.expanduser("~/.fukui-no-namari/whitelist")
try:
    for line in file(whitelist_path):
        _whitelist.append(line.rstrip())
except IOError:
    traceback.print_exc()

_board_reg_expr = re.compile("http://(?P<host>.+)/(?P<board>[^/]+)(?:/[^/]*){0,1}$")


class TypeOther(BaseType):
    bbs_type = "other"
    _board_reg = _board_reg_expr

    def _parse_uri(self, uri):

        def uri_base_match(uri, iru):
            iru = iru.rstrip("/")
            if uri.startswith(iru):
                uri = uri[len(iru):]
                if not uri:
                    return True
                elif uri[0] == "/":
                    uri = uri[1:]
                    if not uri:
                        return True
                    elif uri.find("/") == -1:
                        return True
            return False

        for iru in _whitelist:
            match = self._board_reg.match(iru)
            if match:
                host = match.group("host")
                board = match.group("board")
                if uri_base_match(uri, "http://%s/%s" % (host, board)):
                    self.host = host
                    self.board = board
                    return
                else:
                    cgi_base = "http://%s/test/read.cgi/%s/" % (host, board)
                    if uri.startswith(cgi_base):
                        match = re.match(
                            "(?P<thread>[^/]+)/", uri[len(cgi_base):])
                        if match:
                            self.host = host
                            self.board = board
                            self.thread = match.group("thread")
                            return
            else:
                print "%s in whitelist is not supported" % iru

        raise BbsTypeError, "the uri %s is not supported" % uri
