# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import re
import os.path
import codecs
import urllib2
from misc import get_board_subjecttxt_path
from misc import get_board_idx_path
from http_sub import HTTPRedirectHandler302

REG_EXPR = re.compile("(?P<id>.*).dat<>(?P<title>.*)\((?P<res>\d*)\)")

def expr(line, func):
    m = REG_EXPR.match(line)
    if m:
        id = m.group("id")
        title = m.group("title")
        try:
            res = int(m.group("res"))
        except:
            res = 0
        func(id, title, res)

def analyze_subjecttxt(subjecttxt, func):
    lines = subjecttxt.splitlines()
    for line in lines:
        expr(line, func)
    
def load_subjecttxt(bbs, board, func):
    subjecttxt_path = get_board_subjecttxt_path(bbs, board)
    if not os.path.exists(subjecttxt_path):
        return

    f = open(subjecttxt_path)
    subjecttxt_encoded = f.read()
    f.close()

    analyze_subjecttxt(subjecttxt_encoded.decode("cp932", "replace"), func)

def get_subjecttxt(bbs, board, uri):

    # get subject.txt

    opener = urllib2.build_opener(HTTPRedirectHandler302)
    response = opener.open(uri)
    info = response.info()
    print info
    subjecttxt_encoded = response.read()

    # save subject.txt
    subjecttxt_path = get_board_subjecttxt_path(bbs, board)
    
    basedir = os.path.dirname(subjecttxt_path)
    if not os.path.isdir(basedir):
        os.makedirs(basedir)

    f = open(subjecttxt_path, "w")
    f.write(subjecttxt_encoded)
    f.close()

    lastmod = None
    if "Last-Modified" in info:
        lastmod = info["Last-Modified"]
        save_board_idx(bbs, board, lastmod)

    return subjecttxt_encoded.decode("cp932", "replace"), lastmod

def load_board_idx(bbs, board):
    lastmod = ""
    boardidxfile = get_board_idx_path(bbs, board)
    if os.path.exists(boardidxfile):
        for line in file(boardidxfile):
            if line.startswith("lastModified="):
                lastmod = line[len("lastModified="):].rstrip("\n")
                break
    return lastmod

def save_board_idx(bbs, board, lastmod):
    if not lastmod:
        return

    boardidx_path = get_board_idx_path(bbs, board)
    basedir = os.path.dirname(boardidx_path)
    if not os.path.isdir(basedir):
        os.makedirs(basedir)

    f = file(boardidx_path, "w")
    f.write("lastModified=" + lastmod + "\n")
    f.close()
