# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import threading
import gobject
import os.path
import glob

import subjecttxtfile
import cachefile
import idxfile
import misc

BOARD_DATA_INVALID_VALUE = 0

def merge_new_thread(oldlist, newlist, id, title, res):
    num = len(newlist) + 1
    if id in oldlist:
        item = oldlist.pop(id)
        item["num"] = num
        item["title"] = title
        item["res"] = res
        newlist[id] = item
    else:
        newlist[id] = {"num": num, "title": title,
                        "res": res, "lineCount": BOARD_DATA_INVALID_VALUE,
                        "lastModified": ""}

def merge_cached_thread(oldlist, newlist):
    for id, value in oldlist.iteritems():
        if value["lineCount"] != BOARD_DATA_INVALID_VALUE:
            value["num"] = BOARD_DATA_INVALID_VALUE
            value["res"] = BOARD_DATA_INVALID_VALUE
            newlist[id] = value

def merge_local_subjecttxt(bbs, board, datalist):
    oldlist = datalist.copy()
    datalist.clear()

    h = lambda id,title,res: merge_new_thread(oldlist,datalist,id,title,res)
    subjecttxtfile.load_subjecttxt(bbs, board, h)
    merge_cached_thread(oldlist, datalist)

def merge_subjecttxt(subjecttxt, datalist):
    oldlist = datalist.copy()
    datalist.clear()

    h = lambda id,title,res: merge_new_thread(oldlist,datalist,id,title,res)
    subjecttxtfile.analyze_subjecttxt(subjecttxt, h)
    merge_cached_thread(oldlist, datalist)

def load_idxfiles(bbs, board):
    datalist = {}

    def on_load_record(id, metadata_dic):
        idxfile_path = misc.get_thread_idx_path(bbs, board, id)
        if os.path.exists(idxfile_path):
            datalist[id] = metadata_dic

    print "load_cache"
    cachefile.load_cache(bbs, board, on_load_record)
    print "load_idx"
    load_modified_idxfiles(bbs, board, datalist)
    print "save_cache"
    cachefile.save_cache(bbs, board, datalist)

    return datalist

def load_modified_idxfiles(bbs, board, datalist):
    basedir = misc.get_thread_idx_dir_path(bbs, board)
    if os.path.isdir(basedir):
        for idxfile_path in glob.glob(os.path.join(basedir, "*.idx")):
            thread_id, ext = os.path.splitext(os.path.basename(idxfile_path))
            idxlastModified = os.path.getmtime(idxfile_path)
            if thread_id not in datalist:
                print "new"
                dic = idxfile.load_idx(bbs, board, thread_id)
                #dic.pop("etag")
                dic["idxlastModified"] = idxlastModified
                datalist[thread_id] = dic
            elif idxlastModified > datalist[thread_id]["idxlastModified"]:
                print "modified"
                datalist[thread_id]["idxlastModified"] = idxlastModified
                dic = idxfile.load_idx(bbs, board, thread_id)
                for name in idxfile.metadata_namelist:
                    datalist[thread_id][name] = dic[name]


class LoadLocal(threading.Thread):
    def __init__(self, bbs, board, on_end):
        super(LoadLocal, self).__init__()
        self.bbs = bbs
        self.board = board
        self.on_end = on_end

    def run(self):
        datalist = load_idxfiles(self.bbs, self.board)
        merge_local_subjecttxt(self.bbs, self.board, datalist)
        lastmod = subjecttxtfile.load_board_idx(self.bbs, self.board)
        gobject.idle_add(self.on_end, datalist, lastmod)


class GetRemote(threading.Thread):
    def __init__(self, bbs, board, uri, on_end):
        super(GetRemote, self).__init__()
        self.bbs = bbs
        self.board = board
        self.uri = uri
        self.on_end = on_end

    def run(self):
        print "start get subject.txt"
        subjecttxt, lastmod = subjecttxtfile.get_subjecttxt(
            self.bbs, self.board, self.uri)
        datalist = load_idxfiles(self.bbs, self.board)
        merge_subjecttxt(subjecttxt, datalist)
        gobject.idle_add(self.on_end, datalist, lastmod)
