# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gobject
import codecs
import urllib
import urllib2
import cookielib
import os.path
import time

from BbsType import bbs_type_judge_uri
from BbsType import bbs_type_exception
from HTMLParserEx import HTMLParserEx
import datfile
import uri_opener

GLADE_DIR = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                         "..", "data")
GLADE_FILENAME = "submit_window.glade"

cookie_jar = cookielib.CookieJar()
opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cookie_jar))

def open(uri):
    if not uri:
        raise ValueError, "parameter must not be empty"

    WinWrap(uri)


class ConfirmationHTMLParser(HTMLParserEx):

    def __init__(self):
        HTMLParserEx.__init__(self)
        self.message = ""
        self.inputs = []
        self.complete = False

    def handle_starttag(self, tag, attr):
        if tag == "br":
            self.message += "\n"
        elif tag == "input":
            self.inputs.append(dict(attr))
        elif tag == "meta":
            attr_dict = dict(attr)
            if "http-equiv" in attr_dict \
               and attr_dict["http-equiv"] == "refresh":
                self.complete = True

    def handle_endtag(self, tag):
        pass

    def handle_comment(self, comment):
        print comment.strip()

    def handle_data(self, data):
        self.message += data

    def handle_charref(self, ref):
        data = None
        try:
            data = unichr(int(ref))
        except:
            data = "&#"+ref+";"
        self.message += data

    def handle_entityref(self, name):
        if name in htmlentitydefs.name2codepoint:
            codepoint = htmlentitydefs.name2codepoint[name]
            self.message += unichr(codepoint)
        else:
            self.message += "&"+name+";"


class WinWrap:

    def __init__(self, uri):
        self.uri = uri
        self.bbs_type = bbs_type_judge_uri.get_type(uri)
        if not self.bbs_type.is_thread():
            raise bbs_type_exception.BbsTypeError, \
                  "the uri does not represent thread: " + uri

        glade_path = os.path.join(GLADE_DIR, GLADE_FILENAME)
        self.widget_tree = gtk.glade.XML(glade_path)
        self.window = self.widget_tree.get_widget("submit_window")
        self.entry_name = self.widget_tree.get_widget("entry_name")
        self.entry_mail = self.widget_tree.get_widget("entry_mail")
        self.textbuffer = self.widget_tree.get_widget("textview").get_buffer()

        self.post_dict = {}
        self.post_dict["bbs"] = self.bbs_type.board
        self.post_dict["key"] = self.bbs_type.thread
        self.post_dict["time"] = str(int(time.time()))
        self.post_dict["hana"] = "mogera"
        self.post_dict["submit"] = u"\u66f8\u304d\u8fbc\u3080".encode(
            "cp932", "replace")

        sigdic = {"on_submit_activate": self.on_submit_activate,
                  "on_close_activate": self.on_close_activate}

        self.widget_tree.signal_autoconnect(sigdic)

        title = datfile.get_title_from_dat(
            self.bbs_type.bbs_type, self.bbs_type.board, self.bbs_type.thread)
        if title:
            self.window.set_title(title)

    def on_close_activate(self, widget):
        self.window.destroy()

    def on_submit_activate(self, widget):
        name = self.entry_name.get_text()
        if self.bbs_type.bbs_type == "2ch" \
               and self.bbs_type.board == "morningcoffee" \
               and not name:
            name = u'\u540d\u7121\u3057\u52df\u96c6\u4e2d\u3002\u3002\u3002'
        mail = self.entry_mail.get_text()
        msg = self.textbuffer.get_text(
            self.textbuffer.get_start_iter(), self.textbuffer.get_end_iter())

        self.post_dict["FROM"] = name.encode("cp932", "replace")
        self.post_dict["mail"] = mail.encode("cp932", "replace")
        self.post_dict["MESSAGE"] = msg.encode("cp932", "replace")

        self.do_submit()

    def do_submit(self):
        post_encoded = urllib.urlencode(self.post_dict)
        print post_encoded

        req = urllib2.Request("http://" + self.bbs_type.host + "/test/bbs.cgi",
                              post_encoded)
        req.add_header("Referer", self.uri)

        res = opener.open(req)
        self.on_response(res)

    def on_response(self, response):
        data = response.read()

        p = ConfirmationHTMLParser()
        p.feed(data.decode("cp932", "replace"))
        p.close()

        print data.decode("cp932")

        window = gtk.Window()
        if not p.complete:
            window.set_default_size(500, 500)
        textview = gtk.TextView()
        textview.set_wrap_mode(gtk.WRAP_CHAR)
        textview.set_editable(False)
        buf = textview.get_buffer()
        buf.insert(buf.get_end_iter(), p.message)

        for input in p.inputs:
            if "type" in input and input["type"] == "submit":
                button = gtk.Button(input["value"])
                button.connect("clicked",
                               self.on_button_submit_clicked, p.inputs)
                anchor = buf.create_child_anchor(buf.get_end_iter())
                textview.add_child_at_anchor(button, anchor)
                break

        window.add(textview)
        window.show_all()

        if p.complete:

            def on_timeout(widget):
                widget.destroy()
                uri_opener.open_uri(self.bbs_type.get_thread_uri(), True)

            gobject.timeout_add(2 * 1000, on_timeout, window)

    def on_button_submit_clicked(self, widget, inputs=None):
        widget.get_toplevel().destroy()
        self.post_dict = {}
        for input in inputs:
            if "name" in input and "value" in input:
                name = input["name"]
                value = input["value"]
                self.post_dict[name] = value.encode("cp932", "replace")

        self.do_submit()
