# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os.path
import re
import time

import config

REG_EXPR_HTTPDATE = re.compile("((?:Mon)|(?:Tue)|(?:Wed)|(?:Thu)|(?:Fri)|(?:Sat)|(?:Sun)), (\d{2}) ((?:Jan)|(?:Feb)|(?:Mar)|(?:Apr)|(?:May)|(?:Jun)|(?:Jul)|(?:Aug)|(?:Sep)|(?:Oct)|(?:Nov)|(?:Dec)) (\d{4}) (\d{2}):(\d{2}):(\d{2}) GMT")
WDAY_DICT = {"Mon":0, "Tue":1, "Wed":2, "Thu":3, "Fri":4, "Sat":5, "Sun":6}
MON_DICT = {"Jan":1, "Feb":2, "Mar":3, "Apr":4, "May":5, "Jun":6, "Jul":7,
            "Aug":8, "Sep":9, "Oct":10, "Nov":11, "Dec":12}

def get_logs_dir_path():
    return os.path.join(config.get_config_dir_path(), "logs")

def get_thread_dat_dir_path(bbs, board):
    """Returns dir path for saving thread dat file"""

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_board_dir_path(bbs, board), "dat")

def get_thread_idx_dir_path(bbs, board):
    """Returns dir path for saving thread index file"""

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_board_dir_path(bbs, board), "idx")

def get_thread_dat_path(bbs, board, thread):
    """Returns thread dat file path

    bbs: bbs id

    board: board id

    thread: thread id
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board or not thread:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_thread_dat_dir_path(bbs, board), thread + ".dat")

def get_board_subjecttxt_url(bbs, board):
    """Returns subject.txt file url

    bbs: bbs id

    board: board id
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return get_board_base_url(bbs, board) + "subject.txt"

def get_board_subjecttxt_path(bbs, board):
    """Returns subject.txt file path

    bbs: bbs id

    board: board id
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_logs_dir_path(), bbs, board, "subject.txt")

def get_board_idx_path(bbs, board):
    """Returns board idx file path

    bbs: bbs id

    board: board id
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_logs_dir_path(), bbs, board, "subject.idx")

def get_board_dir_path(bbs, board):
    """Returns board dir path

    bbs: bbs ID

    board: board ID
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_logs_dir_path(), bbs, board)

def get_thread_idx_path(bbs, board, thread):
    """Returns idx file path of thread

    bbs: bbs ID

    board: board ID

    thread: thread ID

    Note: if parameter is empty, raise ValueError
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board or not thread:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_thread_idx_dir_path(bbs, board), thread + ".idx")

def get_board_cache_path(bbs, board):
    """ Returns .cache file path of board

    bbs: bbs ID

    board: board ID

    Note: if parameter is empty, raise ValueError
    """

    # if parameter is empty, raise ValueError
    if not bbs or not board:
        raise ValueError, "parameter must not be empty"

    return os.path.join(get_thread_idx_dir_path(bbs, board), ".cache")

def httpdate_to_secs(httpdate):
    """Returns the seconds since the epoch"""

    m = REG_EXPR_HTTPDATE.match(httpdate)
    if m:
        tm_wday = WDAY_DICT[m.group(1)]
        tm_mday = int(m.group(2))
        tm_mon = MON_DICT[m.group(3)]
        tm_year = int(m.group(4))
        tm_hour = int(m.group(5))
        tm_min = int(m.group(6))
        tm_sec = int(m.group(7))

        return int(time.mktime(
            (tm_year,tm_mon,tm_mday,tm_hour,tm_min,tm_sec,tm_wday,0,-1)) \
            - time.timezone)
    else:
        raise ValueError
