# Copyright (C) 2006 by Aiwota Programmer
# aiwotaprog@tetteke.tk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import re

from bbs_type_exception import BbsTypeError


_base_reg_expr = re.compile("http://(?P<host>[^./]+\.2ch\.net)/(?P<board>[^/]+)/$")
_cgi_reg_expr = re.compile("http://(?P<host>[^./]+\.2ch\.net)/test/read.cgi/(?P<board>[^/]+)/(?P<thread>[^/]+)/.*")


class Type2ch:

    def __init__(self, host=None, board=None, thread=None, uri=None):
        if uri:
            self._parse_uri(uri)
        else:
            if not host or not board:
                raise BbsTypeError, "host and board, or uri must be specified"
            self.uri = uri
            self.host = host
            self.board = board
            self.thread = thread

    def _parse_uri(self, uri):
        self.uri = uri
        self.bbs_type = None
        self.host = None
        self.board = None
        self.thread = None

        m = _base_reg_expr.match(self.uri)
        if m:
            self.bbs_type = "2ch"
            self.host = m.group("host")
            self.board = m.group("board")
        else:
            m = _cgi_reg_expr.match(self.uri)
            if m:
                self.bbs_type = "2ch"
                self.host = m.group("host")
                self.board = m.group("board")
                self.thread = m.group("thread")

    def is_board(self):
        return not self.thread

    def is_thread(self):
        return self.thread

    def clone_with_thread(self, thread):
        if not thread:
            raise ValueError, "parameter must not be empty"
        return Type2ch(self.host, self.board, thread)

    def get_uri_base(self):
        return "http://" + self.host + "/" + self.board + "/"

    def get_subject_txt_uri(self):
        return self.get_uri_base() + "subject.txt"

    def get_dat_uri(self):
        if not self.thread:
            raise BbsTypeError, "not specified thread"
        return self.get_uri_base() + "dat/" + self.thread + ".dat"

    def get_thread_uri(self):
        if not self.thread:
            raise BbsTypeError, "not specified thread"
        return "http://" + self.host + "/test/read.cgi/" + \
                  self.board + "/" + self.thread + "/"
