#!/usr/local/bin/python

import ftpclient,string,getpass,socket,os
from ftpy_define import *
from Tkinter import *
import tkMessageBox,tkSimpleDialog,threading
import time,types

###############################################
#	CUI mode class
###############################################
class ftpcui:
	#Output prompt
	def user_input(self):
		command = raw_input("ftpy> ")
		return command

	#Output help
	def printHelp(self):
		print "bye"
		print "cd <remote_directory>"
		print "chmod <mode> <file_name>"
		print "get <remote_file> <local_file>"
		print "getdir <remote_directory>"
		print "putdir <local_directory>"
		print "help"
		print "lcd <local_directory>"
		print "lpwd"
		print "ls <remote_directory>"
		print "mkdir <directory_name>"
		print "open <hostname>"
		print "put <local_file> <remote_file>"
		print "pwd"
		print "rename <from_filename> <to_filename>"
		print "rmdir <directory_name>"

	#Print normal massege
	def printMassege(self,msg_list):
		for ent in msg_list:
			print ent

	#Print error massege
	def printError(self,err_obj):
		if len(err_obj.args) == 1:
			args = err_obj.args[0]
			print args[4:]
		elif len(err_obj.args) == 2:
			args = err_obj.args[1]
			print args
		
	#FTP Connection to FTP Server
	def connect(self,hostname,portno):
		self.ftpclient.setHostname(hostname)
		self.ftpclient.setPortno(portno)
		if self.ftpclient.connect() == C_OK:
			user = raw_input("Name (" + hostname + "):")
			password = getpass.getpass()
			self.ftpclient.setUser(user)
			self.ftpclient.setPassword(password)
			if self.ftpclient.login() <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
			else:
				self.connectFlag = C_ON
		else:
			self.printError(self.ftpclient.getError_Obj())
			
	#Close Connection
	def bye(self):
		res = self.ftpclient.close()
	
	#Open Connection
	def open(self,command):
		if len(command) == 2:
			if self.connectFlag == C_OFF:
				hostname = command[1]
				try:
					socket.gethostbyname(hostname)
					self.connect(hostname,None)
				except Exception, e:
					print "Could not find server."
			else:
				print "Already connected , use close first."
		else:
			print "usage : open <hostname>"

	#Print remore dir
	def ls(self,command):
		if len(command) > 2:
			print "usage : ls [<pattarn>]"
		elif len(command) == 1:
			if self.ftpclient.getRemoteDirData() == C_OK:
				self.printMassege(self.ftpclient.getRemoteDir_Obj())
			else:
				self.printError(self.ftpclient.getError_Obj())
		elif len(command) == 2:
			if self.ftpclient.getRemoteDirData(command[1]) == C_OK:
				self.printMassege(self.ftpclient.getRemoteDir_Obj())
			else:
				self.printError(self.ftpclient.getError_Obj())

	#Print current dir
	def pwd(self):
		if self.ftpclient.getCurrentRemoteDir() == C_OK:
			self.printMassege(self.ftpclient.getMsg_Obj())
		else:
			self.printError(self.ftpclient.getError_Obj())

	#Change remote dir
	def cd(self,command):
		if len(command) == 2:
			if self.ftpclient.changeRemoteDir(command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : cd <dir_name>"

	#Get file
	def get(self,command):
		if len(command) == 1 or len(command) > 3:
			print "usage : get <remore_filename> [<local_filename>]"
		elif len(command) == 2:
			if self.ftpclient.getRemoteFile(command[1],command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		elif len(command) == 3:
			if self.ftpclient.getRemoteFile(command[1],command[2]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
	
	#Put file
	def put(self,command):
		if len(command) == 1 or len(command) > 3:
			print "usage : put <local_filename> [<remote_filename>]"
		elif len(command) == 2:
			if self.ftpclient.putLocalFile(command[1],command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		elif len(command) == 3:
			if self.ftpclient.putLocalFile(command[2],command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
	
	#Create dir
	def mkdir(self,command):
		if len(command) == 2:
			if self.ftpclient.createRemote_dir(command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : mkdir <dir_name>"

	#Remove dir
	def rmdir(self,command):
		if len(command) == 2:
			if self.ftpclient.removeRemote_dir(command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : rmdir <dir_name>"

	#Remove file
	def rm(self,command):
		if len(command) == 2:
			if self.ftpclient.removeRemoteFile(command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : rm <file_name>"

	#Change mode
	def chmod(self,command):
		if len(command) == 3:
			if self.ftpclient.changeModeRemoteFile(command[2],command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : chmod <mode> <file_name>"

	#Get Directroy
	def getdir(self,command):
		if len(command) == 2:
			if string.find(command[1],"/") >= 0:
				print "sorry <dir_name>/<subdir_name>.. not support"
			else:
				if self.ftpclient.getCurrentLocalDir() == C_OK:
					if self.ftpclient.getRemoteDir(command[1],self.ftpclient.getMsg_Obj()[0]) <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : getdir <dir_name>"
	
	#Put Local Directroy
	def putdir(self,command):
		if len(command) == 2:
			if string.find(command[1],"/") >= 0:
				print "sorry <dir_name>/<subdir_name>.. not support"
			else:
				if self.ftpclient.getCurrentRemoteDir() == C_OK:
					if self.ftpclient.putLocalDir(command[1],self.ftpclient.getMsg_Obj()[0]) <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : putdir <dir_name>"

	
	#Print local current dir
	def lpwd(self):
		if self.ftpclient.getCurrentLocalDir() == C_OK:
			self.printMassege(self.ftpclient.getMsg_Obj())
		else:
			self.printError(self.ftpclient.getError_Obj())

	#Change local dir
	def lcd(self,command):
		if len(command) == 2:
			if self.ftpclient.changeLocalDir(command[1]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : lcd <dir_name>"

	#Rename Remote File
	def rename(self,command):
		if len(command) == 3:
			if self.ftpclient.renameRemoteFile(command[1],command[2]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
		else:
			print "usage : rename <from_filename> <to_filename>"

	#Output Help
	def help(self):
		self.printHelp()

	#Output prompt and Input command
	def prompt(self):
		command = self.user_input()
		command = string.split(command," ")
		res = self.method_call(command)
		return res

	def method_call(self,command):
		cmd = command[0]
		if cmd == "bye":
			self.bye()
			return C_NG
		elif cmd == "open":
			self.open(command)
		elif cmd == "ls":
			self.ls(command)
		elif cmd == "pwd":
			self.pwd()
		elif cmd == "cd":
			self.cd(command)
		elif cmd == "get":
			self.get(command)
		elif cmd == "put":
			self.put(command)
		elif cmd == "mkdir":
			self.mkdir(command)
		elif cmd == "rmdir":
			self.rmdir(command)
		elif cmd == "rm":
			self.rm(command)
		elif cmd == "chmod":
			self.chmod(command)
		elif cmd == "getdir":
			self.getdir(command)
		elif cmd == "putdir":
			self.putdir(command)
		elif cmd == "lpwd":
			self.lpwd()
		elif cmd == "lcd":
			self.lcd(command)
		elif cmd == "rename":
			self.rename(command)
		elif cmd == "help":
			self.help()
		else:
			print "?Invalid command"
		return C_OK
		
	#Main Loop
	def main(self):
		while self.prompt():
			pass

	#Initial
	def __init__(self,pasv):
		self.ftpclient = ftpclient.ftpclient()
		self.connectFlag = C_OFF
		self.ftpclient.setPasvmode(pasv)

###############################################
#	Widget class
###############################################
class FtpyWidget(Frame):

	#Print FTPy widget
	def printGUI(self):
		#Tk
		self.master.title("FTPy-0.2.1")
		
		#Frame 
		frameTop = Frame(self,bg=self.MyConf.Background)
		frameLocal = Frame(self,bg=self.MyConf.Background)
		frameButton = Frame(self,bg=self.MyConf.Background)
		frameRemote = Frame(self,bg=self.MyConf.Background)
		frameMessage = Frame(self,bg=self.MyConf.Background)
		
		#Menu
		self.makeTopMenu()
		
		#Make Widget
		self.makeHostInfoWidget(frameTop)
		self.makeConnectButton(frameTop)
		self.makeLocalListbox(frameLocal)
		self.makeUpDlButton(frameButton)
		self.makeRemoteListbox(frameRemote)
		self.makeMessageText(frameMessage)
		
		#Frame grid
		frameTop.grid(row=0,column=0,columnspan=3,sticky=W)
		frameLocal.grid(row=1,column=0)
		frameButton.grid(row=1,column=1)
		frameRemote.grid(row=1,column=2)
		frameMessage.grid(row=2,column=0,columnspan=3)

	#Make application menus
	def makeTopMenu(self):
		menuTop = Menu(tearoff=1,font=self.MyConf.Font)
		self.makeMenuConnect(menuTop)
		self.makeMenuDisplay(menuTop)
		self.makeMenuBookmark(menuTop)
		self.makeMenuHelp(menuTop)
		self.makeMenuPopupLocal()
		self.makeMenuPopupRemote()
		
	#Menu connect
	def makeMenuConnect(self,menuTop):
		menuConnect = Menu(menuTop,font=self.MyConf.Font)
		menuTop.add_cascade(label="connect",menu=menuConnect)
		menuConnect.add_command(label="connect",command=self.connect)			
		menuConnect.add_command(label="disconnect",command=self.disconnect)
		menuConnect.add_separator()
		menuConnect.add_command(label="abort",command=self.abort)
		menuConnect.add_separator()
		menuConnect.add_command(label="quit",command=self.quit)

	#Menu display
	def makeMenuDisplay(self,menuTop):
		menuDisplay = Menu(menuTop,font=self.MyConf.Font)
		menuTop.add_cascade(label="display",menu=menuDisplay)
		menuDisplay.add_command(label="refresh",command=self.refresh)
		menuDisplay.add_separator()
		menuDisplay.add_command(label="show server system",command=self.showServerSystem)
		menuDisplay.add_command(label="show server status",command=self.showServerStatus)
		menuDisplay.add_command(label="send command",command=self.sendCommand)
		

	#Menu bookmark
	def makeMenuBookmark(self,menuTop):
		self.menuBookmark = Menu(menuTop,font=self.MyConf.Font)
		menuTop.add_cascade(label="bookmark",menu=self.menuBookmark)
		self.menuBookmark.add_command(label="add bookmark",command=self.addBookmark)
		self.menuBookmark.add_command(label="open bookmark...",command=self.openBookmark)
	
	#Menu help
	def makeMenuHelp(self,menuTop):
		menuHelp = Menu(menuTop,font=self.MyConf.Font)
		menuTop.add_cascade(label="help",menu=menuHelp)
		menuHelp.add_command(label="version",command=self.showVersion)
		self.master.config(menu=menuTop)
	
	#Popup menu(Local)
	def makeMenuPopupLocal(self):
		self.menuPopupLocal = Menu(font=self.MyConf.Font)
		self.menuPopupLocal.add_command(label="Create directory",command=self.createLocalDirectory)
		self.menuPopupLocal.add_command(label="Delete directory",command=self.deleteLocalDirectory)
		self.menuPopupLocal.add_separator()
		self.menuPopupLocal.add_command(label="Rename",command=self.renameLocalFile)
		self.menuPopupLocal.add_command(label="Delete File",command=self.deleteLocalFile)
		
	#Popup menu(Remote)
	def makeMenuPopupRemote(self):
		self.menuPopupRemote = Menu(font=self.MyConf.Font)
		self.menuPopupRemote.add_command(label="Create directory",command=self.createRemoteDirectory)
		self.menuPopupRemote.add_command(label="Delete directory",command=self.deleteRemoteDirectory)
		self.menuPopupRemote.add_separator()
		self.menuPopupRemote.add_command(label="Change mode",command=self.changeMode)
		self.menuPopupRemote.add_command(label="Rename",command=self.renameRemoteFile)
		self.menuPopupRemote.add_command(label="Delete File",command=self.deleteRemoteFile)

	#Make host connect infomation widget
	def makeHostInfoWidget(self,frameTop):
		self.HostVar = StringVar(); self.HostVar.set("")
		labelHost = Label(frameTop,text="Hostname",font=self.MyConf.Font)
		self.entryHost = Entry(frameTop,width="20",bg="white",font=self.MyConf.Font,textvariable=self.HostVar)
		self.PortVar = StringVar(); self.PortVar.set("21")
		labelPort = Label(frameTop,text="Port",font=self.MyConf.Font)
		self.entryPort = Entry(frameTop,width="4",bg="white",font=self.MyConf.Font,textvariable=self.PortVar)
		self.UserVar = StringVar(); self.UserVar.set("")
		labelUser = Label(frameTop,text="User",font=self.MyConf.Font)
		self.entryUser = Entry(frameTop,width="10",bg="white",font=self.MyConf.Font,textvariable=self.UserVar)
		self.PassVar = StringVar(); self.PassVar.set("")
		labelPass = Label(frameTop,text="Password",font=self.MyConf.Font)
		self.entryPass = Entry(frameTop,width="10",bg="white",font=self.MyConf.Font,textvariable=self.PassVar,show="*")
		self.PasvVar = IntVar()
		self.chbtnPasv = Checkbutton(frameTop,text="PASV",font=self.MyConf.Font,variable=self.PasvVar,onvalue=C_ON,offvalue=C_OFF)
		self.entryHost.bind("<Return>",self.pressEnter); self.entryPort.bind("<Return>",self.pressEnter)
		self.entryUser.bind("<Return>",self.pressEnter); self.entryPass.bind("<Return>",self.pressEnter)
		labelHost.grid(row=0,column=1); self.entryHost.grid(row=0,column=2)
		labelPort.grid(row=0,column=3); self.entryPort.grid(row=0,column=4)
		labelUser.grid(row=0,column=5); self.entryUser.grid(row=0,column=6)
		labelPass.grid(row=0,column=7); self.entryPass.grid(row=0,column=8)
		self.chbtnPasv.grid(row=0,column=9)
	
	#Make button widget(connect,disconnect)
	def makeConnectButton(self,frameTop):
		#self.btnConnect = Button(frameTop,bitmap="@connect.xbm",width="24",height="24",command=self.connect)
		self.btnConnect = Button(frameTop,bitmap="info",width="24",height="24",command=self.connect)
		self.btnDisconnect = Button(frameTop,bitmap="error",width="24",height="24",command=self.disconnect)
		self.btnConnect.grid(row=0,column=10)
		self.btnDisconnect.grid(row=0,column=11)

	#Make local infomation widget
	def makeLocalListbox(self,frameLocal):
		#Directory path
		self.LocalPathVar = StringVar(); self.LocalPathVar.set("")
		entryLocalPath = Entry(frameLocal,bg="white",width=40,font=self.MyConf.Font,textvariable=self.LocalPathVar)
		entryLocalPath.grid(row=0,column=0,columnspan=2,sticky=W)
		#Directory list
		self.listLocal = Listbox(frameLocal,selectmode=EXTENDED,width=40,height=10,bg="white",font=self.MyConf.Font)
		scrvLocal = Scrollbar(frameLocal,orient=VERTICAL,command=self.listLocal.yview)
		scrhLocal = Scrollbar(frameLocal,orient=HORIZONTAL,command=self.listLocal.xview)
		self.listLocal.config(xscrollcommand=scrhLocal.set,yscrollcommand=scrvLocal.set)
		entryLocalPath.bind("<Return>",self.pressReturnLocal)
		self.listLocal.bind("<Double-Button-1>",self.doubleClickLocal)
		self.listLocal.bind("<ButtonRelease-3>",self.button3ClickLocal)
		self.listLocal.grid(row=1,column=0)
		scrvLocal.grid(row=1,column=1,sticky=NS)
		scrhLocal.grid(row=2,column=0,sticky=EW)
	
	#Make update & download button widget
	def makeUpDlButton(self,frameButton):
		self.btnUpdate = Button(frameButton,text="->",font=self.MyConf.Font,command=self.update)
		self.btnDownload = Button(frameButton,text="<-",font=self.MyConf.Font,command=self.download)
		labelDummy = Label(frameButton,height=3)
		self.btnUpdate.grid(row=0,column=0)
		labelDummy.grid(row=1,column=0)
		self.btnDownload.grid(row=2,column=0)

	#Make remote infomation widget
	def makeRemoteListbox(self,frameRemote):
		#Directory path
		self.RemotePathVar = StringVar(); self.RemotePathVar.set("")
		self.entryRemotePath = Entry(frameRemote,bg="white",width=40,font=self.MyConf.Font,textvariable=self.RemotePathVar)
		self.entryRemotePath.grid(row=0,column=0,columnspan=2,sticky=W)
		#Directory list
		self.listRemote = Listbox(frameRemote,selectmode=EXTENDED,width=40,height=10,bg="white",font=self.MyConf.Font)
		scrvRemote = Scrollbar(frameRemote,orient=VERTICAL,command=self.listRemote.yview)
		scrhRemote = Scrollbar(frameRemote,orient=HORIZONTAL,command=self.listRemote.xview)
		self.listRemote.config(xscrollcommand=scrhRemote.set,yscrollcommand=scrvRemote.set)
		self.entryRemotePath.bind("<Return>",self.pressReturnRemote)
		self.listRemote.bind("<Double-Button-1>",self.doubleClickRemote)
		self.listRemote.bind("<ButtonRelease-3>",self.button3ClickRemote)
		self.listRemote.grid(row=1,column=0)
		scrvRemote.grid(row=1,column=1,sticky=NS)
		scrhRemote.grid(row=2,column=0,sticky=EW)

	#Make application message print widget
	def makeMessageText(self,frameMessage):
		self.textMessage = Text(frameMessage,bg="#d9d9d9",width=90,height=10,font=self.MyConf.Font,state=DISABLED)
		scrvMessage = Scrollbar(frameMessage,orient=VERTICAL,command=self.textMessage.yview)
		self.textMessage.config(yscrollcommand=scrvMessage.set)
		self.textMessage.grid(row=0,column=0)
		scrvMessage.grid(row=0,column=1,sticky=NS)
		self.textMessage.tag_config("red",foreground="red")
		self.textMessage.tag_config("black",foreground="black")
		self.textMessage.tag_config("blue",foreground="blue")

	#Set initial parameter
	def setInitParameter(self,hostname,portno,pasv):
		self.HostVar.set(hostname)
		self.PortVar.set(portno)
		if pasv == C_ON:
			self.PasvVar.set(C_ON)
	
	#Lock HostInfomation wedgets
	def lockHostInfomation(self,lockswitch):
		if lockswitch == C_ON:
			for e in [	self.entryHost,
						self.entryPort,
						self.entryUser,
						self.entryPass]:
				e.config(state=DISABLED,bg="#d9d9d9")
			self.chbtnPasv.config(state=DISABLED)
		else:
			for e in [	self.entryHost,
						self.entryPort,
						self.entryUser,
						self.entryPass]:
				e.config(state=NORMAL,bg="white")
			self.chbtnPasv.config(state=NORMAL)
	
	#Lock RemoteInfomation wedget
	def lockRemoteInfomation(self,lockswitch):
		if lockswitch == C_ON:
			self.entryRemotePath.config(state=DISABLED,bg="#d9d9d9")
			self.listRemote.config(selectmode=BROWSE,bg="#d9d9d9")
			for e in [	self.btnUpdate,
						self.btnDownload,
						self.btnConnect,
						self.btnDisconnect	]:
				e.config(state=DISABLED)
		else:
			self.entryRemotePath.config(state=NORMAL,bg="white")
			self.listRemote.config(selectmode=EXTENDED,bg="white")
			for e in [	self.btnUpdate,
						self.btnDownload,
						self.btnConnect,
						self.btnDisconnect	]:
				e.config(state=NORMAL)
	
	#Print message
	def printMessage(self,color,msg):
		if msg <> None:
			self.textMessage.config(state=NORMAL)
			self.textMessage.insert(END,msg+"\n",color)
			self.textMessage.config(state=DISABLED)
			self.textMessage.yview(MOVETO,1)
	
	#Print error massege
	def printError(self,err_obj):
		if types.StringType == type(err_obj):
			self.printMessage(C_RED,err_obj)
		elif types.InstanceType == type(err_obj):
			for e in err_obj.args:
				self.printMessage(C_RED,str(e))
		else:
			for e in err_obj:
				self.printMessage(C_RED,e)
			
	#Retrun Connection Parameter
	def getConPara(self):
		return self.HostVar.get(), self.PortVar.get(), self.UserVar.get(), self.PassVar.get()
	
	#Print Wait dot(Ex: ......)
	def printWaitingDot(self):
				self.textMessage.config(state=NORMAL)
				self.textMessage.insert(END,".")
				self.textMessage.config(state=DISABLED)


###############################################
#	GUI mode class
###############################################
class ftpgui(FtpyWidget):

	#-----------------------------------------#
	#          Initial                        #
	#-----------------------------------------#
	#Class initial
	def __init__(self,hostname="",portno=21,pasv=C_OFF):
		Frame.__init__(self,master=None)
		self.pack()
		self.MyConf = FtpyConf()
		self.printGUI()
		self.setInitParameter(hostname,portno,pasv)
		self.ftpclient = ftpclient.ftpclient()
		self.refreshLocalList()
		self.connectFlag = C_OFF
		self.lockFlag = C_OFF
	
	#-----------------------------------------#
	#          Procedure -Thread-             #
	#-----------------------------------------#
	def threading(self,method_name=None,method_args=(),obj_size=0):
		while self.lockFlag == C_ON:
			time.sleep(0.3)
		self.lockFlag = C_ON
		thread_connect = threading.Thread(target=method_name,args=method_args)
		thread_connect.start()
		thread_wait = threading.Thread(target=self.waitThread,args=(thread_connect,obj_size))
		thread_wait.start()
		return C_OK
		
	def waitThread(self,thread_obj,obj_size):
		self.lockRemoteInfomation(C_ON)
		stime = ftime = time.time()
		while thread_obj.isAlive():
			ntime = time.time()
			if ntime - ftime > 1:
				self.printWaitingDot()
				ftime = ntime
				time.sleep(1)
		etime = time.time() - stime
		if obj_size <> 0:
			if obj_size / etime > 1000:
				bps = str(int((obj_size / etime) / 1000))+"Kbps"
			else:
				bps = str(int(obj_size / etime))+"bps"
			self.printMessage(C_BLACK," "+str(int(etime))+"sec("+bps+")")
		else:
			self.printMessage(C_BLACK," "+str(int(etime))+"sec")
		self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
		self.lockRemoteInfomation(C_OFF)
		self.lockFlag = C_OFF
		
	#-----------------------------------------#
	#          Procedure -Connection-         #
	#-----------------------------------------#
	#Connecting to FTP server
	def connect(self):
		#Check connection
		if self.connectFlag == C_ON:
			self.printError("Already connected , use close first")
		else:
			#Get connecting parameters
			hostname,portno,user,password = self.getConPara()
			if user == "":
				user = "anonymous"
			#Check connection parameters
			if self.checkConPara(hostname,portno) <> C_NG:
				#Set connection parameters
				self.setConPara(hostname,portno,user,password)
				#Check hostname
				if self.checkHostname(hostname) <> C_OK:
					self.printError(hostname + " is not found")
					return C_NG
				else:
					#Check Pasv mode
					self.ftpclient.setPasvmode(self.PasvVar.get())
					#Connecting FTP server start
					self.printMessage(C_BLACK,"Connect(" + hostname + ":" + portno + ")")
					if self.ftpclient.connect() == C_OK:
						self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
						self.connectFlag = C_ON
						#Login to FTP server
						self.printMessage(C_BLACK,"Login(" + user + ")")
						work_thread = threading.Thread(target=self.threadLogin)
						work_thread.start()
					else:
						self.printError(self.ftpclient.getError_Obj())
	
	#Thread Login
	def threadLogin(self):
		res = self.ftpclient.login()
		while self.lockFlag == C_ON:
			time.sleep(0.5)
		if res == C_OK:
			self.lockHostInfomation(C_ON)
			self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
			self.refreshRemoteList()
		else:
			self.printError(self.ftpclient.getError_Obj())

	#Provide Connection Parameter to FTPClient Class
	def setConPara(self,hostname,portno,user,password):
		self.ftpclient.setHostname(hostname)
		self.ftpclient.setPortno(portno)
		self.ftpclient.setUser(user)
		self.ftpclient.setPassword(password)

	#Check Connection Paramete(Hostname,PortNo)
	def checkConPara(self,hostname,portno):
		if hostname == "":
			self.printError("Please input hostname")
			return C_NG
		if portno == "":
			self.printError("Please input portno")
			return C_NG
		return C_OK

	#Check hostname
	def checkHostname(self,hostname):
		try:
			socket.gethostbyname(hostname)
			return C_OK
		except Exception, e:
			return C_NG

	#Disconnect FTP server
	def disconnect(self):
		if self.connectFlag <> C_ON:
			self.printError("Has not connection")
		else:
			self.printMessage(C_BLACK,"Disconnect")
			if self.ftpclient.close() <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
			else:
				#clear to remote widget
				self.lockHostInfomation(C_OFF)
				self.listRemote.delete(0,END)
				self.RemotePathVar.set("")
				self.connectFlag = C_OFF
				if self.ftpclient.getReturnMsg() == None:
					self.printError("999 Timeout: closing control connection")
				else:
					self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())

	#Abort
	def abort(self):
		if self.connectFlag == C_ON:
			self.printMessage(C_BLACK,"ABORT")
			if self.ftpclient.abort() <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
			else:
				self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
		else:
			self.printError("Has not connection")
	
	#FTPy quit
	def quit(self):
		self.disconnect()
		self.master.destroy()

	#-----------------------------------------#
	#          Procedure -Help-               #
	#-----------------------------------------#
	#Output version infomation
	def showVersion(self):
		wOpenVersion = version()
		wOpenVersion.init()
	
	#-----------------------------------------#
	#          Procedure -File Transfe-       #
	#-----------------------------------------#
	#File update(Local -> Remote)
	def update(self):
		work_thread = threading.Thread(target=self.threadUpdate)
		work_thread.start()
	
	def threadUpdate(self):
		for index in self.listLocal.curselection():
			item = self.listLocal.get(index)
			if item[0] == "-":	#File
				objname = item[string.rfind(item," ")+1:]
				line = self.splitDirEntry(item)
				filesize = self.convFileSign(line[1])
				res = self.threading(method_name=self.ftpclient.putLocalFile,method_args=(objname,objname),obj_size=filesize)
			elif item[0] == "d":	#Directory
				objname = item[string.rfind(item," ")+1:]
				res = self.threading(method_name=self.ftpclient.putLocalDir,method_args=(objname,self.RemotePathVar.get()))
			if res == C_OK:
				self.printMessage(C_BLACK,"STOR "+self.LocalPathVar.get()+"/"+objname)
			else:
				self.printError(self.ftpclient.getError_Obj())
			while self.lockFlag == C_ON:
				time.sleep(0.5)
		time.sleep(0.5)
		self.refreshRemoteList()

	def convFileSign(self,filesize):
		if filesize[-1] == "M":
			filesize = long(filesize[:-1])*1000000
		elif filesize[-1] == "K":
			filesize = long(filesize[:-1])*1000
		else:
			filesize = long(filesize)
		return filesize		

	#File download(Remote -> Local)
	def download(self):
		work_thread = threading.Thread(target=self.threadDownload)
		work_thread.start()
	
	def threadDownload(self):
		#Get select file(s)
		for index in self.listRemote.curselection():
			item = self.listRemote.get(index)
			objname = item[string.rfind(item," ")+1:]
			if item[0] == "-":	#File
				line = self.splitDirEntry(item)
				filesize = self.convFileSign(line[1])
				res = self.threading(method_name=self.ftpclient.getRemoteFile,method_args=(objname,objname),obj_size=filesize)
			elif item[0] == "d":	#Directory
				res = self.threading(method_name=self.ftpclient.getRemoteDir,method_args=(objname,self.LocalPathVar.get()))
			if res == C_OK:
				self.printMessage(C_BLACK,"RETR "+self.RemotePathVar.get()+objname)
			else:
				self.printError(self.ftpclient.getError_Obj())
		while self.lockFlag == C_ON:
			time.sleep(0.5)
		self.refreshLocalList()
			
	#-----------------------------------------#
	#          Procedure -Directory-          #
	#-----------------------------------------#
	#Refresh dirctory list(Local,Remote)
	def refresh(self):
		self.refreshLocalList()
		if self.lockFlag == C_OFF and self.connectFlag == C_ON:
			self.refreshRemoteList()

	#Refresh local directory list
	def refreshLocalList(self):
		if self.ftpclient.getCurrentLocalDir() <> C_OK:
			self.printError(self.ftpclient.getError_Obj())
		else:
			#Get local current directory
			current_dir = self.ftpclient.getMsg_Obj()
			self.LocalPathVar.set(current_dir[0])
			self.listLocal.delete(0,END)
			if self.ftpclient.getLocalDirData(current_dir[0]) <> C_OK:
				self.printError(self.ftpclient.getError_Obj())
			else:
				#Get local directory data
				dir_obj = self.ftpclient.getLocalDir_Obj()
				dir_obj.sort()
				#Insert local directory entry
				self.listLocal.insert(END,"d ..")
				for e in dir_obj:
					filesize = str(os.path.getsize(e))
					filesize,sep = self.convFileSize(filesize)
					if os.path.isfile(e):
						item = "- " + filesize + sep + e
					elif os.path.isdir(e):
						item = "d " + filesize + sep + e
					elif os.path.islink(e):
						item = "l " + filesize + sep + e
					else:
						item = "? " + filesize + sep + e
					self.listLocal.insert(END,item)
	
	#Refresh remote directory list
	def refreshRemoteList(self):
		#Get remote current directory
		current_dir = self.getRemoteCurrentDir()
		self.listRemote.delete(0,END)
		if self.ftpclient.getRemoteDirData() <> C_OK:
			self.printError(self.ftpclient.getError_Obj())
		else:
			dir_obj = self.ftpclient.getRemoteDir_Obj()
			#Insert remote directory entry
			self.listRemote.insert(END,"d ..")
			for e in dir_obj:
				line_ent = self.splitDirEntry(e)
				if len(line_ent) > 5:
					permission = line_ent[0] 
					filename = line_ent[len(line_ent)-1]
					if len(line_ent) == 9:
						filesize = line_ent[4]
					elif len(line_ent) == 8:
						filesize = line_ent[3]
					else:
						filesize = "0"
					filesize,sep = self.convFileSize(filesize)
					item = permission + filesize + sep + filename 
					self.listRemote.insert(END,item)

	#Return Remote current Directroy
	def getRemoteCurrentDir(self):
		if self.ftpclient.getCurrentRemoteDir() <> C_OK:
			self.printError(self.ftpclient.getError_Obj())
		else:
			current_dir = self.ftpclient.getMsg_Obj()
			if current_dir[0] <> "/":
				current_dir[0] = current_dir[0] + "/"
			self.RemotePathVar.set(current_dir[0])
			return current_dir

	#Convert File Size
	def convFileSize(self,filesize):
		sep = "  "
		if int(self.MyConf.FileSizeSign) == C_ON:
			if long(filesize) >= 1000000:
				filesize = str(long(filesize) / 1000000)
				sep = "M "
			elif long(filesize) >= 1000:
				filesize = str(long(filesize) / 1000)
				sep = "K "
		filesize = " " * (11 - len(filesize)) + str(filesize)
		return filesize,sep
			
	#Split directory entry
	def splitDirEntry(self,entry):
		line_ent = []
		for e in string.split(entry," "):
			if e <> "":
				line_ent.append(e)
		return line_ent
	
	#Show FTP Server System
	def showServerSystem(self):
		if self.connectFlag == C_ON:
			if self.ftpclient.getServerSystem() == C_OK:
				self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
			else:
				self.printError(self.ftpclient.getError_Obj())
		else:
			self.printError("Has not connection")
	
	#Show FTP Server Status
	def showServerStatus(self):
		if self.connectFlag == C_ON:
			if self.ftpclient.getServerStatus() == C_OK:
				self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
			else:
				self.printError(self.ftpclient.getError_Obj())
		else:
			self.printError("Has not connection")

	#Send User Command
	def sendCommand(self):
		if self.connectFlag == C_ON:
			cmd = tkSimpleDialog.askstring("Send Command","User Command")
			self.printMessage(C_BLACK,cmd)
			if self.ftpclient.sendUserCmd(cmd) == C_OK:
				self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
			else:
				self.printError(self.ftpclient.getError_Obj())
		else:
			self.printError("Has not connection")

	#-----------------------------------------#
	#          Procedure -Remote Control-     #
	#-----------------------------------------#
	#Change mode(Remote)
	def changeMode(self):
		select_indexes = self.listRemote.curselection()
		if len(select_indexes) <> 0:
			mode = tkSimpleDialog.askstring("Change Mode","Mode\nexampl:744 +x")
			if mode <> None:
				for index in select_indexes:
					item = self.listRemote.get(index)
					#Check item
					if item[0] == "-" or item[0] == "d":	#File,Dirctory
						objname = item[string.rfind(item," ")+1:]
						self.printMessage(C_BLACK,"SITE CHMOD "+mode+" "+objname)
						if self.ftpclient.changeModeRemoteFile(objname,mode) == C_OK:
							self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
							self.refreshRemoteList()
						else:
							self.printError(self.ftpclient.getError_Obj())

	#Create directory(Remote)
	def createRemoteDirectory(self):
		if self.connectFlag == C_ON:
			dirname = tkSimpleDialog.askstring("Create Directory","Directory Name")
			if dirname <> None:
				self.printMessage(C_BLACK,"MKD "+dirname)
				if self.ftpclient.createRemote_dir(dirname) == C_OK:
					self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
					self.refreshRemoteList()
				else:
					self.printError(self.ftpclient.getError_Obj())
		else:
			self.printError("Has not connection")

	#Delete Remote directory
	def deleteRemoteDirectory(self):
		#Get select item
		select_indexes = self.listRemote.curselection()
		if len(select_indexes) <> 0:
			selectlist = list(select_indexes)
			selectlist.reverse()
			for index in selectlist:
				item = self.listRemote.get(index)
				#Check item
				if item[0] == "d":	#Directory
					dir_name = item[string.rfind(item," ")+1:]
					self.printMessage(C_BLACK,"RMD "+dir_name)
					#Delete file
					if self.ftpclient.removeRemote_dir(dir_name) <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
					else:
						self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
				else:
					objname = item[string.rfind(item," ")+1:]
					self.printError(objname+" is not directory")
				
	#Delete remote file
	def deleteRemoteFile(self):
		#Get select item
		select_indexes = self.listRemote.curselection()
		if len(select_indexes) <> 0:
			selectlist = list(select_indexes)
			selectlist.reverse()
			for index in selectlist:
				item = self.listRemote.get(index)
				#Check item
				if item[0] == "-":	#File
					filename = item[string.rfind(item," ")+1:]
					self.printMessage(C_BLACK,"DELE "+filename)
					#Delete file
					res = self.ftpclient.removeRemoteFile(filename)
					if res <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
					else:
						self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
						self.refreshRemoteList()
				else:
					objname = item[string.rfind(item," ")+1:]
					self.printError(objname+" is not file")
			

	#Rename remote file,object
	def renameRemoteFile(self):
		#Get select item
		select_indexes = self.listRemote.curselection()
		if len(select_indexes) == 1:
			item = self.listRemote.get(select_indexes[0])
			#Check item
			if item[0] == "d" or item[0] == "-":	#Directory or File
				fromname = item[string.rfind(item," ")+1:]
				toname = tkSimpleDialog.askstring("Rename","To filename")
				if toname <> None:
					self.printMessage(C_BLACK,"RNFR "+fromname)
					self.printMessage(C_BLACK,"RNTO "+toname)
					res = self.ftpclient.renameRemoteFile(fromname,toname)
					if res <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
					else:
						self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
						self.refreshRemoteList()

	#-----------------------------------------#
	#          Procedure -Local Control-      #
	#-----------------------------------------#
	#Create directory(Local)
	def createLocalDirectory(self):
		dirname = tkSimpleDialog.askstring("Create Directory","Directory Name")
		if dirname <> None:
			self.printMessage(C_BLACK,"mkdir "+dirname)
			if self.ftpclient.createLocalDir(dirname) == C_OK:
				self.printMessage(C_BLUE,"OK")
				self.refreshLocalList()
			else:
				self.printError(self.ftpclient.getError_Obj())

	#Delete local directory
	def deleteLocalDirectory(self):
		#Get select item
		select_indexes = self.listLocal.curselection()
		if len(select_indexes) <> 0:
			selectlist = list(select_indexes)
			selectlist.reverse()
			for index in selectlist:
				item = self.listLocal.get(index)
				#Check item
				if item[0] == "d":	#Dirctory
					dirname = item[string.rfind(item," ")+1:]
					self.printMessage(C_BLACK,"rmdir "+dirname)
					#Delete Directory
					if self.ftpclient.deleteLocalDirectory(dirname) <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
					else:
						self.printMessage(C_BLUE,"OK")
						self.refreshLocalList()
				else:
					objname = item[string.rfind(item," ")+1:]
					self.printError(objname+" is not directory")
				
	#Delete file(Local)
	def deleteLocalFile(self):
		#Get select item
		select_indexes = self.listLocal.curselection()
		if len(select_indexes) <> 0:
			selectlist = list(select_indexes)
			selectlist.reverse()
			for index in selectlist:
				item = self.listLocal.get(index)
				#Check item
				if item[0] == "-":	#File
					filename = item[string.rfind(item," ")+1:]
					self.printMessage(C_BLACK,"rm "+filename)
					#Delete file
					if self.ftpclient.deleteLocalFile(filename) <> C_OK:
						self.PrintError(self.ftpclient.getError_Obj())
					else:
						self.printMessage(C_BLUE,"OK")
						self.refreshLocalList()
				else:
					objname = item[string.rfind(item," ")+1:]
					self.printError(objname+" is not file")

	#Rename file,object(Local)
	def renameLocalFile(self):
		#Get select item
		select_indexes = self.listLocal.curselection()
		if len(select_indexes) == 1:
			item = self.listLocal.get(select_indexes[0])
			#Check item
			if item[0] == "d" or item[0] == "-":	#Directory or File
				fromname = item[string.rfind(item," ")+1:]
				toname = tkSimpleDialog.askstring("Rename","To filename")
				if toname <> None:
					self.printMessage(C_BLACK,"mv "+fromname+" "+toname)
					if self.ftpclient.renameLocalFile(fromname,toname) <> C_OK:
						self.printError(self.ftpclient.getError_Obj())
					else:
						self.refreshLocalList()
						self.printMessage(C_BLUE,"OK")

	#-----------------------------------------#
	#          Procedure -Event Remote-       #
	#-----------------------------------------#
	#Press Return event(Remote)
	def pressReturnRemote(self,event):
		if self.lockFlag == C_OFF and self.connectFlag == C_ON:
			self.printMessage(C_BLACK,"CWD "+self.RemotePathVar.get())
			work_thread = threading.Thread(target=self.threadChangeDir)
			work_thread.start()
		else:
			self.printError("Has not connection")

	def threadChangeDir(self):
		res = self.ftpclient.changeRemoteDir(self.RemotePathVar.get())
		while self.lockFlag == C_ON:
			time.sleep(0.5)
		if res == C_OK:
			self.printMessage(C_BLUE,self.ftpclient.getReturnMsg())
			self.refreshRemoteList()
		else:
			self.printError(self.ftpclient.getError_Obj())
			self.getRemoteCurrentDir()
				
	#Double click event(Remote)
	def doubleClickRemote(self,event):
		if self.lockFlag <> C_ON:
			#Get select item
			select_indexes = self.listRemote.curselection()
			if len(select_indexes) == 1:
				item = self.listRemote.get(select_indexes[0])
				#Check item
				if item[0] == "d":	#Directory
					dirname = item[string.rfind(item," ")+1:]
					self.RemotePathVar.set(self.RemotePathVar.get() + dirname + "/")
					self.printMessage(C_BLACK,"CWD "+dirname)
					#Change remote directory
					work_thread = threading.Thread(target=self.threadChangeDir)
					work_thread.start()

	#Button3 Click(Remote)
	def button3ClickRemote(self,event):
		if self.lockFlag <> C_ON:
			self.menuPopupRemote.tk_popup(event.x_root,event.y_root)

	#-----------------------------------------#
	#          Procedure -Event Local-        #
	#-----------------------------------------#
	#Press Return event(Local)
	def pressReturnLocal(self,event):
		self.printMessage(C_BLACK,"lcd "+self.LocalPathVar.get())
		if self.ftpclient.changeLocalDir(self.LocalPathVar.get()) == C_OK:
			self.printMessage(C_BLUE,"OK")
			self.refreshLocalList()
		else:
			self.printError(self.ftpclient.getError_Obj())

	
	#Double click event(Local)
	def doubleClickLocal(self,event):
		#Get select item
		select_indexes = self.listLocal.curselection()
		if len(select_indexes) <> 0:
			item = self.listLocal.get(select_indexes[0])
			#Check item
			if item[0] == "d":	#Directory
				dirname = item[string.rfind(item," ")+1:]
				self.printMessage(C_BLACK,"lcd "+dirname)
				#Change local directory
				if self.ftpclient.changeLocalDir(dirname) <> C_OK:
					self.printError(self.ftpclient.getError_Obj())
				else:
					self.printMessage(C_BLUE,"OK")
					self.refreshLocalList()

	#Button3 Click(Local)
	def button3ClickLocal(self,event):
		self.menuPopupLocal.tk_popup(event.x_root,event.y_root)

	#-----------------------------------------#
	#          Procedure -Event Common-       #
	#-----------------------------------------#
	#Entry press
	def pressEnter(self,event):
		self.connect()

	#-----------------------------------------#
	#          Procedure -Bookmark Control-   #
	#-----------------------------------------#
	#Add Bookmark
	def addBookmark(self):
		try:
			ftpysetup = FtpySetup()
			filepath = ftpysetup.getFilePath("bookmark")
			fileBookmark = open(filepath,"a")
			host = self.HostVar.get()
			port = self.PortVar.get()
			user = self.UserVar.get()
			passwd = self.PassVar.get()
			pasv = self.PasvVar.get()
			if host <> "":
				item = host + ":" + port + ":" + user + ":" + passwd + ":" + str(pasv) + "\n"
				fileBookmark.write(item)
			else:
				self.printError("Please input hostname")
			fileBookmark.close()
		except Exception, e:
			self.printError(e)

	#Open Bookmark
	def openBookmark(self):
		wOpenBookmark = bookmark()
		wOpenBookmark.init()
		self.wait_window(wOpenBookmark)
		if wOpenBookmark.selectItem <> "":
			item = string.split(wOpenBookmark.selectItem,":")
			self.HostVar.set(item[0])	
			self.PortVar.set(item[1])	
			self.UserVar.set(item[2])	
			self.PassVar.set(item[3])
			self.PasvVar.set(int(item[4]))

	
###############################################
#	Version class
###############################################
class version(Toplevel):

	#Class initial
	def init(self):
		master=None
		Toplevel.__init__(self,master)
		self.MyConf = FtpyConf()
		self.printVersion()
		self.grab_set()

	#Print bookmark
	def printVersion(self):
		self.title("Version")
		frameMain = Frame(self)
		textVersion = Text(frameMain,bg="#d9d9d9",font=self.MyConf.Font,height=7,width=60,state=DISABLED)
		btnOK = Button(frameMain,text="OK",font=self.MyConf.Font,command=self.pushOK)
		frameMain.grid(row=0,column=0)
		textVersion.grid(row=1,column=0)
		btnOK.grid(row=2,column=0)

		msg = [
		"FTPy\n\n",
		"Version 0.2.1\n",
		"Copyright(c) 2002 Shinkichi <shinkichi@user.sourceforge.jp>\n"
		"http://ftpy.sourceforge.jp/\n"
		"GNU GPL"
		]
		textVersion.config(state=NORMAL)
		for e in msg:
			textVersion.insert(END,e)
		textVersion.config(state=DISABLED)

	#Pushed OK Button
	def pushOK(self):
		self.destroy()


###############################################
#	Bookmark class
###############################################
class bookmark(Toplevel):

	#Class initial
	def init(self):
		master=None
		Toplevel.__init__(self,master)
		self.MyConf = FtpyConf()
		self.printBookmark()
		self.printBookmarkList()
		self.grab_set()
		self.selectItem = ""

	#Print bookmark
	def printBookmark(self):
		### Tk ###
		self.title("Bookmark")
		
		### Frame ###
		frameMain = Frame(self)
		frameButton = Frame(self)

		### Menu ###
		self.menuPopup = Menu(font=self.MyConf.Font)
		self.menuPopup.add_command(label="delete",command=self.delete)

		### Listbox ###
		self.listBookmark = Listbox(frameMain,selectmode=SINGLE,width=40,height=10,bg="white",font=self.MyConf.Font)
		scrvBookmark = Scrollbar(frameMain,orient=VERTICAL,command=self.listBookmark.yview)
		scrhBookmark = Scrollbar(frameMain,orient=HORIZONTAL,command=self.listBookmark.xview)
		self.listBookmark.config(xscrollcommand=scrhBookmark.set,yscrollcommand=scrvBookmark.set)
		self.listBookmark.grid(row=1,column=0)
		scrvBookmark.grid(row=1,column=1,sticky=NS)
		scrhBookmark.grid(row=2,column=0,sticky=EW)
		self.listBookmark.bind("<ButtonRelease-3>",self.popupMenu)
		self.listBookmark.bind("<Double-Button-1>",self.doubleClick)
		
		### Button ###
		btnOK = Button(frameButton,text="OK",font=self.MyConf.Font,command=self.pushOK)
		btnCancel = Button(frameButton,text="Cancel",font=self.MyConf.Font,command=self.pushCancel)
		btnOK.grid(row=0,column=0)
		btnCancel.grid(row=0,column=1)
		
		
		### Frame grid ###
		frameMain.grid(row=0,column=0)
		frameButton.grid(row=1,column=0)

	#Pushed OK Button
	def pushOK(self):
		self.writeBookmark()
		#Get select item
		indexed = self.listBookmark.curselection()
		if len(indexed) == 0:
			self.destroy()
		else:
			item = self.bookmarks[int(indexed[0])]
			self.selectItem = item[:-1]
			self.destroy()
	
	#Pushed Cancel Button
	def pushCancel(self):
		self.destroy()

	#Read bookmark file
	def readBookmark(self):
		try:	
			ftpysetup = FtpySetup()
			filepath = ftpysetup.getFilePath("bookmark")
			fileBookmark = open(filepath,"r")

			self.bookmarks = []
			self.bookmarks = fileBookmark.readlines()
			
			fileBookmark.close()
			
			return self.bookmarks
		except IOError, e:
			tkMessageBox.showerror(title="Not found",message="Bookmark file open Error.")
			return [];
		except Exception, e:
			tkMessageBox.showerror(title="Error",message=e)
			self.destroy()

	#Write bookmark file
	def writeBookmark(self):
		try:
			ftpysetup = FtpySetup()
			filepath = ftpysetup.getFilePath("bookmark")
			fileBookmark = open(filepath,"w")
			
			for e in self.bookmarks:
				fileBookmark.write(e)
			fileBookmark.close()
		except Exception, e:
			tkMessageBox.showerror(title="Error",message=e)
			self.destroy()

	#Print bookmark list
	def printBookmarkList(self):
		bookmarks = []
		bookmarks = self.readBookmark()
		if len(bookmarks) > 0:
			for e in bookmarks:
				item = []
				item = string.split(e,":")
				item[3] = "******"
				if int(item[4][0]) == C_ON:
					item[4] = "PASV"
				else:
					item[4] = "NO PASV"
				self.listBookmark.insert(END,string.join(item,":"))
	
	#Popup Menu
	def popupMenu(self,event):
		self.menuPopup.tk_popup(event.x_root,event.y_root)
	
	#Delete item
	def delete(self):
		#Get select item
		indexed = self.listBookmark.curselection()
		if len(indexed) <> 0:
			self.listBookmark.delete(indexed[0])
			del self.bookmarks[int(indexed[0])]
	
	#Doble click
	def doubleClick(self,event):
		self.pushOK()

###############################################
#	Application Config class
###############################################
class FtpyConf:
	def __init__(self):
	
		ftpysetup = FtpySetup()
		filepath = ftpysetup.getFilePath("ftpy.conf")

		#Open config file
		conf_file = open(filepath,"r")
		
		#Read data
		conf_data = conf_file.readlines()
		
		#Mapping config data
		data = self.mapConf(conf_data)
		
		#Set data
		self.Font = data.get("Font")
		self.FileSizeSign = data.get("FileSizeSign")
		self.Background = data.get("Background")

		#Close config file
		conf_file.close()
		
	def mapConf(self,data):
		result = {}
		for line in data:
			line_data = line[:-1]
			if line_data <> "" and line_data[0] <> "#":
				variable,value = string.split(line_data,"=")
				result.update({variable:value})
		return result
	
###############################################
#	Application Setup class
###############################################
class FtpySetup:
	def getFilePath(self,filename):
		if os.environ.has_key('HOME'):
			ftpypath = os.path.join(os.environ['HOME'],".ftpy")
		else:
			ftpypath = "."
		filepath = os.path.join(ftpypath,filename)
		if os.path.isdir(ftpypath):
			if os.path.isfile(filepath):
				pass
			else:
				if filename == "ftpy.conf":
					self.makeNewConfigFile(filepath)
				elif filename == "bookmark":
					self.makeNewBookmark(filepath)
		else:
			self.makeNewConfigDir(ftpypath)
			self.makeNewConfigFile(os.path.join(ftpypath,"ftpy.conf"))
			self.makeNewBookmark(os.path.join(ftpypath,"bookmark"))

		return filepath

	def makeNewConfigFile(self,filepath):
		
		conf_data = [
		"#<font_name> <font_size>\n"
		"Font=system 10\n",
		"\n"
		"# K,M Display:1 No Display:0\n"
		"FileSizeSign=1\n",
		"\n"
		"#Application Form Background Color\n"
		"Background=#d9d9d9\n"
		]
		
		conf_file = open(filepath,"w")
		conf_file.writelines(conf_data)
		conf_file.close()
			
	def makeNewBookmark(self,filepath):
		bookmark_data = [
		"ftp.ring.gr.jp:21:::0\n"
		"ftp.microsoft.com:21:::0\n"
		"ftp.iij.ad.jp:21:::0\n"
		]
		
		conf_file = open(filepath,"w")
		conf_file.writelines(bookmark_data)
		conf_file.close()
			
	def makeNewConfigDir(self,ftpypath):
		os.mkdir(ftpypath)
	
