#!/usr/locl/bin/python

import ftpclient,string,getpass,socket,os
from ftpy_define import *
from Tkinter import *
import tkMessageBox
import tkSimpleDialog

###############################################
#	CUI mode class
###############################################
class ftpcui:
	#Output prompt
	def user_input(self):
		command = raw_input("ftpy> ")
		return command

	#Output help
	def printHelp(self):
		print "bye"
		print "cd <remote_directory>"
		print "chmod <mode> <file_name>"
		print "get <remote_file> <local_file>"
		print "getdir <remote_directory>"
		print "help"
		print "lcd <local_directory>"
		print "lpwd"
		print "ls <remote_directory>"
		print "mkdir <directory_name>"
		print "open <hostname>"
		print "put <local_file> <remote_file>"
		print "pwd"
		print "rename <from_filename> <to_filename>"
		print "rmdir <directory_name>"

	#Print normal massege
	def printMassege(self,msg_list):
		for ent in msg_list:
			print ent

	#Print error massege
	def printError(self,err_msg,err_obj):
		if len(err_obj.args) == 1:
			args = err_obj.args[0]
			print "%s %s" % (err_msg,args[4:])
		elif len(err_obj.args) == 2:
			args = err_obj.args[1]
			print "%s %s" % (err_msg,args)
		else:
			print err_msg
		
	#FTP Connection to FTP Server
	def connect(self,hostname,portno):
		self.ftpclient.setHostname(hostname)
		self.ftpclient.setPortno(portno)
		res = self.ftpclient.connect()
		if res == C_OK:
			user = raw_input("Name (" + hostname + "):")
			password = getpass.getpass()
			self.ftpclient.setUser(user)
			self.ftpclient.setPassword(password)
			res = self.ftpclient.login()
			if res <> C_OK:
				self.printError("Login Failure:",self.ftpclient.getError_Obj())
			else:
				self.connectFlag = C_ON
		else:
			self.printError("Connection Error:",self.ftpclient.getError_Obj())
			
	#Close Connection
	def bye(self):
		res = self.ftpclient.close()
	
	#Open Connection
	def open(self,command):
		if len(command) == 2:
			if self.connectFlag == C_OFF:
				hostname = command[1]
				try:
					socket.gethostbyname(hostname)
					self.connect(hostname,None)
				except Exception, e:
					print "Could not find server."
			else:
				print "Already connected , use close first."
		else:
			print "usage : open <hostname>"

	#Print remore dir
	def ls(self,command):
		if len(command) > 2:
			print "usage : ls [<pattarn>]"
		elif len(command) == 1:
			res = self.ftpclient.getRemoteDirData()
			if res == C_OK:
				self.printMassege(self.ftpclient.getRemoteDir_Obj())
			else:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		elif len(command) == 2:
			res = self.ftpclient.getRemoteDirData(command[1])
			if res == C_OK:
				self.printMassege(self.ftpclient.getRemoteDir_Obj())
			else:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())

	#Print current dir
	def pwd(self):
		res = self.ftpclient.getCurrentRemoteDir()
		if res == C_OK:
			self.printMassege(self.ftpclient.getMsg_Obj())
		else:
			self.printError("Connection Error:",self.ftpclient.getError_Obj())

	#Change remote dir
	def cd(self,command):
		if len(command) == 2:
			res = self.ftpclient.changeRemoteDir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : cd <dir_name>"

	#Get file
	def get(self,command):
		if len(command) == 1 or len(command) > 3:
			print "usage : get <remore_filename> [<local_filename>]"
		elif len(command) == 2:
			res = self.ftpclient.getRemoteFile(command[1],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		elif len(command) == 3:
			res = self.ftpclient.getRemoteFile(command[1],command[2])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
	
	#Put file
	def put(self,command):
		if len(command) == 1 or len(command) > 3:
			print "usage : put <local_filename> [<remote_filename>]"
		elif len(command) == 2:
			res = self.ftpclient.putLocalFile(command[1],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		elif len(command) == 3:
			res = self.ftpclient.putLocalFile(command[2],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
	
	#Create dir
	def mkdir(self,command):
		if len(command) == 2:
			res = self.ftpclient.createRemote_dir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : mkdir <dir_name>"

	#Remove dir
	def rmdir(self,command):
		if len(command) == 2:
			res = self.ftpclient.removeRemote_dir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : rmdir <dir_name>"

	#Remove file
	def rm(self,command):
		if len(command) == 2:
			res = self.ftpclient.removeRemoteFile(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : rm <file_name>"

	#Change mode
	def chmod(self,command):
		if len(command) == 3:
			res = self.ftpclient.changeModeRemoteFile(command[2],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : chmod <mode> <file_name>"

	#Get Directroy
	def getdir(self,command):
		if len(command) == 2:
			if string.find(command[1],"/") >= 0:
				print string.find(command[1],"/")
				print "sorry <dir_name>/<subdir_name>.. not support"
			else:
				res = self.ftpclient.getRemoteDir(command[1])
				if res <> C_OK:
					self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : getdir <dir_name>"
	
	#Print local current dir
	def lpwd(self):
		res = self.ftpclient.getCurrentLocalDir()
		if res == C_OK:
			self.printMassege(self.ftpclient.getMsg_Obj())
		else:
			self.printError("Connection Error:",self.ftpclient.getError_Obj())

	#Change local dir
	def lcd(self,command):
		if len(command) == 2:
			res = self.ftpclient.changeLocalDir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : lcd <dir_name>"

	#Rename Remote File
	def rename(self,command):
		if len(command) == 3:
			res = self.ftpclient.renameRemoteFile(command[1],command[2])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : rename <from_filename> <to_filename>"

	#Output Help
	def help(self):
		self.printHelp()

	#Output prompt and Input command
	def prompt(self):
		command = self.user_input()
		command = string.split(command," ")
		res = self.method_call(command)
		return res

	def method_call(self,command):
	
		if command[0] == "bye":
			self.bye()
			return C_NG
		elif command[0] == "open":
			self.open(command)
		elif command[0] == "ls":
			self.ls(command)
		elif command[0] == "pwd":
			self.pwd()
		elif command[0] == "cd":
			self.cd(command)
		elif command[0] == "get":
			self.get(command)
		elif command[0] == "put":
			self.put(command)
		elif command[0] == "mkdir":
			self.mkdir(command)
		elif command[0] == "rmdir":
			self.rmdir(command)
		elif command[0] == "rm":
			self.rm(command)
		elif command[0] == "chmod":
			self.chmod(command)
		elif command[0] == "getdir":
			self.getdir(command)
		elif command[0] == "lpwd":
			self.lpwd()
		elif command[0] == "lcd":
			self.lcd(command)
		elif command[0] == "rename":
			self.rename(command)
		elif command[0] == "help":
			self.help()
		else:
			print "?Invalid command"
		return C_OK
		
	#Main Loop
	def main(self):
		while self.prompt():
			pass

	#Initial
	def __init__(self,pacv):
		self.ftpclient = ftpclient.ftpclient()
		self.connectFlag = C_OFF
		if pacv == C_OK:
			self.ftpclient.setPasvmode()

###############################################
#	GUI mode class
###############################################
class ftpgui(Frame):

	#-----------------------------------------#
	#          Initial                        #
	#-----------------------------------------#
	#Class initial
	def __init__(self,hostname="",portno=21,pasv=C_OFF):
		master=None
		Frame.__init__(self,master)
		self.pack()
		self.printGUI()
		self.HostVar.set(hostname)
		self.PortVar.set(portno)
		self.ftpclient = ftpclient.ftpclient()
		self.refreshLocalList()
		self.connectFlag = C_OFF
		if pasv == C_ON:
			self.ftpclient.setPasvmode()
			
	#-----------------------------------------#
	#          Widget                         #
	#-----------------------------------------#
	#Print FTPy widget
	def printGUI(self):
		#Tk
		self.master.title("FTPy-0.1.2")
		
		#Frame 
		frameTop = Frame(self)
		frameLocal = Frame(self)
		frameButton = Frame(self)
		frameRemote = Frame(self)
		frameMessage = Frame(self)
		
		#Menu
		self.makeTopMenu()
		
		#Make Widget
		self.makeHostInfoWidget(frameTop)
		self.makeConnectButton(frameTop)
		self.makeLocalListbox(frameLocal)
		self.makeUpDlButton(frameButton)
		self.makeRemoteListbox(frameRemote)
		self.makeMessageText(frameMessage)
		
		#Frame grid
		frameTop.grid(row=0,column=0,columnspan=3,sticky=W)
		frameLocal.grid(row=1,column=0)
		frameButton.grid(row=1,column=1)
		frameRemote.grid(row=1,column=2)
		frameMessage.grid(row=2,column=0,columnspan=3)

	#Make application menus
	def makeTopMenu(self):
		menuTop = Menu(tearoff=1,font="system 10")
		self.makeMenuConnect(menuTop)
		self.makeMenuDisplay(menuTop)
		self.makeMenuBookmark(menuTop)
		self.makeMenuHelp(menuTop)
		self.makeMenuPopup()
		
	#Menu connect
	def makeMenuConnect(self,menuTop):
		menuConnect = Menu(menuTop,font="system 10")
		menuTop.add_cascade(label="connect",menu=menuConnect)
		menuConnect.add_command(label="connect",command=self.connect)			
		menuConnect.add_command(label="disconnect",command=self.disconnect)
		menuConnect.add_command(label="quit",command=self.quit)

	#Menu display
	def makeMenuDisplay(self,menuTop):
		menuDisplay = Menu(menuTop,font="system 10")
		menuTop.add_cascade(label="display",menu=menuDisplay)
		menuDisplay.add_command(label="refresh",command=self.refresh)

	#Menu bookmark
	def makeMenuBookmark(self,menuTop):
		self.menuBookmark = Menu(menuTop,font="system 10")
		menuTop.add_cascade(label="bookmark",menu=self.menuBookmark)
		self.menuBookmark.add_command(label="add bookmark",command=self.addBookmark)
		self.menuBookmark.add_command(label="open bookmark...",command=self.openBookmark)
	
	#Menu help
	def makeMenuHelp(self,menuTop):
		menuHelp = Menu(menuTop,font="system 10")
		menuTop.add_cascade(label="help",menu=menuHelp)
		menuHelp.add_command(label="version",command=self.showVersion)
		self.master.config(menu=menuTop)
	
	#Popup menu(Remote)
	def makeMenuPopup(self):
		self.menuPopupRemote = Menu(font="system 10")
		self.menuPopupRemote.add_command(label="Change mode",command=self.changeMode)
		self.menuPopupRemote.add_command(label="Create directory",command=self.createDirectory)
		self.menuPopupRemote.add_command(label="Delete File",command=self.deleteRemoteFile)
		self.menuPopupRemote.add_command(label="Rename",command=self.renameFile)

	#Make host connect infomation widget
	def makeHostInfoWidget(self,frameTop):
		self.HostVar = StringVar(); self.HostVar.set("")
		labelHost = Label(frameTop,text="Hostname",font="system 10")
		entryHost = Entry(frameTop,width="20",bg="white",font="system 10",textvariable=self.HostVar)
		self.PortVar = StringVar(); self.PortVar.set("21")
		labelPort = Label(frameTop,text="Port",font="system 10")
		entryPort = Entry(frameTop,width="4",bg="white",font="system 10",textvariable=self.PortVar)
		self.UserVar = StringVar(); self.UserVar.set("")
		labelUser = Label(frameTop,text="User",font="system 10")
		entryUser = Entry(frameTop,width="10",bg="white",font="system 10",textvariable=self.UserVar)
		self.PassVar = StringVar(); self.PassVar.set("")
		labelPass = Label(frameTop,text="Password",font="system 10")
		entryPass = Entry(frameTop,width="10",bg="white",font="system 10",textvariable=self.PassVar,show="*")
		entryHost.bind("<Return>",self.pressEnter); entryPort.bind("<Return>",self.pressEnter)
		entryUser.bind("<Return>",self.pressEnter); entryPass.bind("<Return>",self.pressEnter)
		labelHost.grid(row=0,column=1); entryHost.grid(row=0,column=2)
		labelPort.grid(row=0,column=3); entryPort.grid(row=0,column=4)
		labelUser.grid(row=0,column=5); entryUser.grid(row=0,column=6)
		labelPass.grid(row=0,column=7); entryPass.grid(row=0,column=8)
	
	#Make button widget(connect,disconnect)
	def makeConnectButton(self,frameTop):
		btnConnect = Button(frameTop,bitmap="@connect.xbm",width="24",height="24",command=self.connect)
		btnDisconnect = Button(frameTop,bitmap="error",width="24",height="24",command=self.disconnect)
		btnConnect.grid(row=0,column=9)
		btnDisconnect.grid(row=0,column=10)

	#Make local infomation widget
	def makeLocalListbox(self,frameLocal):
		#Directory path
		self.LocalPathVar = StringVar(); self.LocalPathVar.set("")
		entryLocalPath = Entry(frameLocal,width=40,font="system 10",textvariable=self.LocalPathVar,state=DISABLED)
		entryLocalPath.grid(row=0,column=0,columnspan=2,sticky=W)
		#Directory list
		self.listLocal = Listbox(frameLocal,selectmode=EXTENDED,width=40,height=10,bg="white",font="system 10")
		scrvLocal = Scrollbar(frameLocal,orient=VERTICAL,command=self.listLocal.yview)
		scrhLocal = Scrollbar(frameLocal,orient=HORIZONTAL,command=self.listLocal.xview)
		self.listLocal.config(xscrollcommand=scrhLocal.set,yscrollcommand=scrvLocal.set)
		self.listLocal.bind("<Double-Button-1>",self.doubleClickLocal)
		self.listLocal.grid(row=1,column=0)
		scrvLocal.grid(row=1,column=1,sticky=NS)
		scrhLocal.grid(row=2,column=0,sticky=EW)
	
	#Make update & download button widget
	def makeUpDlButton(self,frameButton):
		btnUpdate = Button(frameButton,text="->",font="system 10",command=self.update)
		btnDownload = Button(frameButton,text="<-",font="system 10",command=self.download)
		btnUpdate.grid(row=0,column=0)
		btnDownload.grid(row=1,column=0)

	#Make remote infomation widget
	def makeRemoteListbox(self,frameRemote):
		#Directory path
		self.RemotePathVar = StringVar(); self.RemotePathVar.set("")
		entryRemotePath = Entry(frameRemote,width=40,font="system 10",textvariable=self.RemotePathVar,state=DISABLED)
		entryRemotePath.grid(row=0,column=0,columnspan=2,sticky=W)
		#Directory list
		self.listRemote = Listbox(frameRemote,selectmode=EXTENDED,width=40,height=10,bg="white",font="system 10")
		scrvRemote = Scrollbar(frameRemote,orient=VERTICAL,command=self.listRemote.yview)
		scrhRemote = Scrollbar(frameRemote,orient=HORIZONTAL,command=self.listRemote.xview)
		self.listRemote.config(xscrollcommand=scrhRemote.set,yscrollcommand=scrvRemote.set)
		self.listRemote.bind("<Double-Button-1>",self.doubleClickRemote)
		self.listRemote.bind("<ButtonRelease-3>",self.button3ClickRemote)
		self.listRemote.grid(row=1,column=0)
		scrvRemote.grid(row=1,column=1,sticky=NS)
		scrhRemote.grid(row=2,column=0,sticky=EW)

	#Make application message print widget
	def makeMessageText(self,frameMessage):
		self.textMessage = Text(frameMessage,width=88,height=6,font="system 10",state=DISABLED)
		scrvMessage = Scrollbar(frameMessage,orient=VERTICAL,command=self.textMessage.yview)
		self.textMessage.config(yscrollcommand=scrvMessage.set)
		self.textMessage.grid(row=0,column=0)
		scrvMessage.grid(row=0,column=1,sticky=NS)
		self.textMessage.tag_config("red",foreground="red")
		self.textMessage.tag_config("black",foreground="black")
		self.textMessage.tag_config("blue",foreground="blue")
	
	#-----------------------------------------#
	#          Procedure                      #
	#-----------------------------------------#
	#Print message
	def printMessage(self,color,msg):
		self.textMessage.config(state=NORMAL)
		self.textMessage.insert(END,msg,color)
		self.textMessage.config(state=DISABLED)
		self.textMessage.yview(MOVETO,1)
	
	#Print error massege
	def printError(self,err_obj):
		for e in err_obj:
			self.printMessage(C_RED,e)
		self.printMessage(C_BLACK,"\n")
	
	#Connecting to FTP server
	def connect(self):
		#Check connection
		if self.connectFlag == C_ON:
			self.printMessage(C_RED,"Already connected , use close first\n")
			return C_NG
		#Get connecting parameters
		hostname	= self.HostVar.get()
		portno 		= self.PortVar.get()
		user 		= self.UserVar.get()
		password 	= self.PassVar.get()
		if user == "":
			user = "anonymous"
		#Check connection parameters
		if hostname == "":
			self.printMessage(C_RED,"Please input hostname\n")
			return C_NG
		if portno == "":
			self.printMessage(C_RED,"Please input portno\n")
			return C_NG
		#Set connection parameters
		self.ftpclient.setHostname(hostname)
		self.ftpclient.setPortno(portno)
		self.ftpclient.setUser(user)
		self.ftpclient.setPassword(password)
		#Check hostname
		self.printMessage(C_BLACK,"Check Hostname(" + hostname + ")..")
		res = self.checkHostname(hostname)
		if res <> C_OK:
			self.printMessage(C_RED,hostname + " is not found\n")
			return C_NG
		else:
			self.printMessage(C_BLUE,"OK\n")
		#Connecting FTP server start
		self.printMessage(C_BLACK,"Connect(" + hostname + ":" + portno + ")..")
		res = self.ftpclient.connect()
		if res == C_OK:
			self.printMessage(C_BLUE,"OK\n")
			self.connectFlag = C_ON
			#Login to FTP server
			self.printMessage(C_BLACK,"Login(" + user + ")..")
			res = self.ftpclient.login()
			if res == C_OK:
				self.refreshRemoteList()
				self.printMessage(C_BLUE,"OK\n")
			else:
				self.printMessage(C_RED,"Failure\n")
		else:
			self.printMessage(C_RED,"Failure\n")

	#Check hostname
	def checkHostname(self,hostname):
		try:
			socket.gethostbyname(hostname)
			return C_OK
		except Exception, e:
			return C_NG

	#Disconnect to FTP server
	def disconnect(self):
		if self.connectFlag == C_ON:
			self.printMessage(C_BLACK,"Disconnect..")
			res = self.ftpclient.close()
			if res <> C_OK:
				self.printMessage(C_RED,"Failure\n")
				return C_NG
			#clear to remote widget
			self.listRemote.delete(0,END)
			self.RemotePathVar.set("")
			self.connectFlag = C_OFF
			self.printMessage(C_BLUE,"OK\n")

	#FTPy quit
	def quit(self):
		self.disconnect()
		self.master.destroy()

	#Output version infomation
	def showVersion(self):
		tkMessageBox.showinfo(title="Version",message="FTPy\nVersion 0.1.2\nCreater:shinkichi")
	
	#File update(Local -> Remote)
	def update(self):
		#Get select file(s)
		select_indexes = self.listLocal.curselection()
		if len(select_indexes) == 0:
			return C_NG
		for index in select_indexes:
			item = self.listLocal.get(index)
			if item[0] == "-":	#File
				filename = item[string.rfind(item," ")+1:]
				self.printMessage(C_BLACK,"Update(" + filename + ")..")
				res = self.ftpclient.putLocalFile(filename,filename)
				if res == C_OK:
					self.printMessage(C_BLUE,"OK\n")
					self.refreshRemoteList()
				else:
					self.printMessage(C_RED,"Failure\n")
	
	#File download(Remote -> Local)
	def download(self):
		#Get select file(s)
		select_indexes = self.listRemote.curselection()
		if len(select_indexes) == 0:
			return C_NG
		for index in select_indexes:
			item = self.listRemote.get(index)
			objname = item[string.rfind(item," ")+1:]
			self.printMessage(C_BLACK,"Download(" + objname + ")..")
			if item[0] == "-":	#File
				res = self.ftpclient.getRemoteFile(objname,objname)
			elif item[0] == "d":	#Directory
				res = self.ftpclient.getRemoteDir(objname)
			if res == C_OK:
				self.printMessage(C_BLUE,"OK\n")
				self.refreshLocalList()
			else:
				self.printMessage(C_RED,"Failure\n")

	#Refresh dirctory list(Local,Remote)
	def refresh(self):
		self.refreshLocalList()
		self.refreshRemoteList()

	#Refresh local directory list
	def refreshLocalList(self):
		#Call getCurrentLocalDir method
		res = self.ftpclient.getCurrentLocalDir()
		if res <> C_OK:
			self.printMessage(C_BLACK,"Connection..Failure\n")
			return C_NG
		#Get local current directory
		current_dir = self.ftpclient.getMsg_Obj()
		self.LocalPathVar.set(current_dir[0])
		#Clear local directory list
		self.listLocal.delete(0,END)
		res = self.ftpclient.getLocalDirData(current_dir[0])
		if res <> C_OK:
			self.printMessage(C_RED,"Connection..Failure\n")
			return C_NG
		#Get local directory data
		dir_obj = []
		dir_obj = self.ftpclient.getLocalDir_Obj()
		dir_obj.sort()
		#Insert local directory entry
		self.listLocal.insert(END,"d ..")
		for e in dir_obj:
			filesize = str(os.path.getsize(e))
			filesize = " " * (11 - len(filesize)) + str(filesize)
			if e[0] <> ".":
				if os.path.isfile(e):
					item = "- " + filesize + " " + e
				elif os.path.isdir(e):
					item = "d " + filesize + " " + e
				elif os.path.islink(e):
					item = "l " + filesize + " " + e
				else:
					item = "? " + filesize + " " + e
				self.listLocal.insert(END,item)
	
	#Refresh remote directory list
	def refreshRemoteList(self):
		#Get remote current directory
		res = self.ftpclient.getCurrentRemoteDir()
		if res <> C_OK:
			self.printMessage(C_RED,"Connection..Failure\n")
			return C_NG
		current_dir = self.ftpclient.getMsg_Obj()
		self.RemotePathVar.set(current_dir[0])
		#Clear remote directory list
		self.listRemote.delete(0,END)
		#Get remote directory data 
		res = self.ftpclient.getRemoteDirData()
		if res <> C_OK:
			self.printMessage(C_RED,"Connection..Failure\n")
			return C_NG
		dir_obj = []
		dir_obj = self.ftpclient.getRemoteDir_Obj()
		#Insert remote directory entry
		if current_dir[0] <> "/":
			self.listRemote.insert(END,"d ..")
		for e in dir_obj:
			if e[0] == "d" or e[0] == "-":
				line_ent = []
				line_ent = self.splitDirEntry(e)
				permission = line_ent[0] 
				filename = line_ent[len(line_ent)-1]
				if e[0] == "-":
					filesize = str(self.ftpclient.getRemoteFileSize(filename))
				else:
					filesize = "4096"
				if len(filesize) < 10:
					add_space = " " * (11 - len(filesize))
					filesize = add_space + filesize
				item = permission + filesize + " " + filename 
				self.listRemote.insert(END,item)

	#Split directory entry
	def splitDirEntry(self,entry):
		line_ent = []
		for e in string.split(entry," "):
			if e <> "":
				line_ent.append(e)
		return line_ent

	#Change mode(Remote)
	def changeMode(self):
		indexed = self.listRemote.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listRemote.get(indexed[0])
		#Check item
		if item[0] == "-" or item[0] == "d":	#File,Dirctory
			objname = item[string.rfind(item," ")+1:]
		mode = tkSimpleDialog.askstring("Change Mode","Mode\nexampl:744 +x")
		if mode <> None:
			self.printMessage(C_BLACK,"chmod(" + mode + ")..")
			res = self.ftpclient.changeModeRemoteFile(objname,mode)
			if res == C_OK:
				self.printMessage(C_BLUE,"OK\n")
				self.refreshRemoteList()
			else:
				self.printError(self.ftpclient.getError_Obj())
				return C_NG

	#Create directory(Remote)
	def createDirectory(self):
		dirname = tkSimpleDialog.askstring("Create Directory","Directory Name")
		if dirname <> None:
			self.printMessage(C_BLACK,"mkdir(" + dirname + ")..")
			res = self.ftpclient.createRemote_dir(dirname)
			if res == C_OK:
				self.printMessage(C_BLUE,"OK\n")
				self.refreshRemoteList()
			else:
				self.printError(self.ftpclient.getError_Obj())
				return C_NG
				

	#Double click event(Remote)
	def doubleClickRemote(self,event):
		#Get select item
		indexed = self.listRemote.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listRemote.get(indexed[0])
		#Check item
		if item[0] == "d":	#Directory
			dirname = item[string.rfind(item," ")+1:]
			self.printMessage(C_BLACK,"cd(" + dirname + ")..")
			#Change remote directory
			res = self.ftpclient.changeRemoteDir(dirname)
			if res <> C_OK:
				self.printMessage(C_RED,"Connection..Failure\n")
				return C_NG
			self.printMessage(C_BLUE,"OK\n")
			self.refreshRemoteList()

	#Double click event(Local)
	def doubleClickLocal(self,event):
		#Get select item
		indexed = self.listLocal.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listLocal.get(indexed[0])
		#Check item
		if item[0] == "d":	#Directory
			dirname = item[string.rfind(item," ")+1:]
			self.printMessage(C_BLACK,"lcd(" + dirname + ")..")
			#Change local directory
			res = self.ftpclient.changeLocalDir(dirname)
			if res <> C_OK:
				self.printMessage(C_RED,"Connection..Failure\n")
				return C_NG
			self.printMessage(C_BLUE,"OK\n")
			self.refreshLocalList()

	#Delete remote file
	def deleteRemoteFile(self):
		#Get select item
		indexed = self.listRemote.curselection()
		if len(indexed) == 0:
			return C_NG
		selectlist = list(indexed)
		selectlist.reverse()
		for e in selectlist:
			item = self.listRemote.get(e)
			#Check item
			if item[0] == "-":	#File
				filename = item[string.rfind(item," ")+1:]
				self.printMessage(C_BLACK,"rm(" + filename + ")..")
				#Delete file
				res = self.ftpclient.removeRemoteFile(filename)
				if res <> C_OK:
					self.printMessage(C_RED,"Connection..Failure\n")
					return C_NG
				self.printMessage(C_BLUE,"OK\n")
				self.refreshRemoteList()
			

	#Rename remote file,object
	def renameFile(self):
		#Get select item
		indexed = self.listRemote.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listRemote.get(indexed[0])
		#Check item
		if item[0] == "d" or item[0] == "-":	#Directory or File
			fromname = item[string.rfind(item," ")+1:]
			toname = tkSimpleDialog.askstring("Rename","To filename")
			if toname <> "":
				self.printMessage(C_BLACK,"rename(" + fromname + " -> " + toname + ")..")
				res = self.ftpclient.renameRemoteFile(fromname,toname)
				if res <> C_OK:
					self.printMessage(C_RED,"Connection..Failure\n")
					return C_NG
				self.printMessage(C_BLUE,"OK\n")
				self.refreshRemoteList()


	#Entry press
	def pressEnter(self,event):
		self.connect()

	#Button3 Click(Remote)
	def button3ClickRemote(self,event):
		self.menuPopupRemote.tk_popup(event.x_root,event.y_root)

	#Add Bookmark
	def addBookmark(self):
		try:
			fileBookmark = open("bookmark","a")
			host = self.HostVar.get()
			port = self.PortVar.get()
			user = self.UserVar.get()
			passwd = self.PassVar.get()
			item = host + ":" + port + ":" + user + ":" + passwd + "\n"
			fileBookmark.write(item)
			fileBookmark.close()
		except Exception, e:
			self.printError(e)

	#Open Bookmark
	def openBookmark(self):
		wOpenBookmark = bookmark()
		wOpenBookmark.init()
		self.wait_window(wOpenBookmark)
		result = wOpenBookmark.selectItem
		if result <> "":
			item = string.split(result,":")
			self.HostVar.set(item[0])	
			self.PortVar.set(item[1])	
			self.UserVar.set(item[2])	
			self.PassVar.set(item[3])	
		

	
###############################################
#	Bookmark class
###############################################
class bookmark(Toplevel):

	#Class initial
	def init(self):
		master=None
		Toplevel.__init__(self,master)
		self.printBookmark()
		self.printBookmarkList()
		self.grab_set()
		self.selectItem = ""

	#Print bookmark
	def printBookmark(self):
		### Tk ###
		self.title("Bookmark")
		
		### Frame ###
		frameMain = Frame(self)
		frameButton = Frame(self)

		### Menu ###
		self.menuPopup = Menu(font="system 10")
		self.menuPopup.add_command(label="delete",command=self.delete)

		### Listbox ###
		self.listBookmark = Listbox(frameMain,selectmode=SINGLE,width=40,height=10,bg="white",font="system 10")
		scrvBookmark = Scrollbar(frameMain,orient=VERTICAL,command=self.listBookmark.yview)
		scrhBookmark = Scrollbar(frameMain,orient=HORIZONTAL,command=self.listBookmark.xview)
		self.listBookmark.config(xscrollcommand=scrhBookmark.set,yscrollcommand=scrvBookmark.set)
		self.listBookmark.grid(row=1,column=0)
		scrvBookmark.grid(row=1,column=1,sticky=NS)
		scrhBookmark.grid(row=2,column=0,sticky=EW)
		self.listBookmark.bind("<ButtonRelease-3>",self.popupMenu)
		self.listBookmark.bind("<Double-Button-1>",self.doubleClick)
		
		### Button ###
		btnOK = Button(frameButton,text="OK",font="system 10",command=self.pushOK)
		btnCancel = Button(frameButton,text="Cancel",font="system 10",command=self.pushCancel)
		btnOK.grid(row=0,column=0)
		btnCancel.grid(row=0,column=1)
		
		
		### Frame grid ###
		frameMain.grid(row=0,column=0)
		frameButton.grid(row=1,column=0)

	#Pushed OK Button
	def pushOK(self):
		self.writeBookmark()
		#Get select item
		indexed = self.listBookmark.curselection()
		if len(indexed) == 0:
			self.destroy()
			return C_NG
		item = self.bookmarks[int(indexed[0])]
		self.selectItem = item[:-1]
		self.destroy()
	
	#Pushed Cancel Button
	def pushCancel(self):
		self.destroy()

	#Read bookmark file
	def readBookmark(self):
		try:	
			self.bookmarks = []
			fileBookmark = open("bookmark","r")
			self.bookmarks = fileBookmark.readlines()
			fileBookmark.close()
			return self.bookmarks
		except IOError, e:
			tkMessageBox.showerror(title="Not found",message="Bookmark file not found.")
			return [];
		except Exception, e:
			tkMessageBox.showerror(title="Error",message=e)
			self.destroy()

	#Write bookmark file
	def writeBookmark(self):
		try:
			fileBookmark = open("bookmark","w")
			for e in self.bookmarks:
				fileBookmark.write(e)
			fileBookmark.close()
		except Exception, e:
			tkMessageBox.showerror(title="Error",message=e)
			self.destroy()

	#Print bookmark list
	def printBookmarkList(self):
		bookmarks = []
		bookmarks = self.readBookmark()
		if len(bookmarks) > 0:
			for e in bookmarks:
				item = []
				item = string.split(e,":")
				item[3] = "******"
				self.listBookmark.insert(END,string.join(item,":"))
	
	#Popup Menu
	def popupMenu(self,event):
		self.menuPopup.tk_popup(event.x_root,event.y_root)
	
	#Delete item
	def delete(self):
		#Get select item
		indexed = self.listBookmark.curselection()
		if len(indexed) == 0:
			return C_NG
		self.listBookmark.delete(indexed[0])
		del self.bookmarks[int(indexed[0])]
	
	#Doble click
	def doubleClick(self,event):
		self.pushOK()
