#!/usr/locl/bin/python

import ftpclient,string,getpass,socket,os
from ftpy_define import *
from Tkinter import *
import tkMessageBox
import tkSimpleDialog

###############################################
#	CUI mode class
###############################################
class ftpcui:
	#Output prompt
	def user_input(self):
		command = raw_input("ftpy> ")
		return command

	#Output help
	def printHelp(self):
		print "bye"
		print "cd <remote_directory>"
		print "chmod <mode> <file_name>"
		print "get <remote_file> <local_file>"
		print "getdir <remote_directory>"
		print "help"
		print "lcd <local_directory>"
		print "lpwd"
		print "ls <remote_directory>"
		print "mkdir <directory_name>"
		print "open <hostname>"
		print "put <local_file> <remote_file>"
		print "pwd"
		print "rename <from_filename> <to_filename>"
		print "rmdir <directory_name>"

	#Print normal massege
	def printMassege(self,msg_list):
		for ent in msg_list:
			print ent

	#Print error massege
	def printError(self,err_msg,err_obj):
		if len(err_obj.args) == 1:
			args = err_obj.args[0]
			print "%s %s" % (err_msg,args[4:])
		elif len(err_obj.args) == 2:
			args = err_obj.args[1]
			print "%s %s" % (err_msg,args)
		else:
			print err_msg
		
	#FTP Connection to FTP Server
	def connect(self,hostname,portno):
		self.ftpclient.setHostname(hostname)
		self.ftpclient.setPortno(portno)
		res = self.ftpclient.connect()
		if res == C_OK:
			user = raw_input("Name (" + hostname + "):")
			password = getpass.getpass()
			self.ftpclient.setUser(user)
			self.ftpclient.setPassword(password)
			res = self.ftpclient.login()
			if res <> C_OK:
				self.printError("Login Failure:",self.ftpclient.getError_Obj())
			else:
				self.connectFlag = C_ON
		else:
			self.printError("Connection Error:",self.ftpclient.getError_Obj())
			
	#Close Connection
	def bye(self):
		res = self.ftpclient.close()
	
	#Open Connection
	def open(self,command):
		if len(command) == 2:
			if self.connectFlag == C_OFF:
				hostname = command[1]
				try:
					socket.gethostbyname(hostname)
					self.connect(hostname,None)
				except Exception, e:
					print "Could not find server."
			else:
				print "Already connected , use close first."
		else:
			print "usage : open <hostname>"

	#Print remore dir
	def ls(self,command):
		if len(command) > 2:
			print "usage : ls [<pattarn>]"
		elif len(command) == 1:
			res = self.ftpclient.getRemoteDirData()
			if res == C_OK:
				self.printMassege(self.ftpclient.getRemoteDir_Obj())
			else:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		elif len(command) == 2:
			res = self.ftpclient.getRemoteDirData(command[1])
			if res == C_OK:
				self.printMassege(self.ftpclient.getRemoteDir_Obj())
			else:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())

	#Print current dir
	def pwd(self):
		res = self.ftpclient.getCurrentRemoteDir()
		if res == C_OK:
			self.printMassege(self.ftpclient.getMsg_Obj())
		else:
			self.printError("Connection Error:",self.ftpclient.getError_Obj())

	#Change remote dir
	def cd(self,command):
		if len(command) == 2:
			res = self.ftpclient.changeRemoteDir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : cd <dir_name>"

	#Get file
	def get(self,command):
		if len(command) == 1 or len(command) > 3:
			print "usage : get <remore_filename> [<local_filename>]"
		elif len(command) == 2:
			res = self.ftpclient.getRemoteFile(command[1],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		elif len(command) == 3:
			res = self.ftpclient.getRemoteFile(command[1],command[2])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
	
	#Put file
	def put(self,command):
		if len(command) == 1 or len(command) > 3:
			print "usage : put <local_filename> [<remote_filename>]"
		elif len(command) == 2:
			res = self.ftpclient.putLocalFile(command[1],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		elif len(command) == 3:
			res = self.ftpclient.putLocalFile(command[2],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
	
	#Create dir
	def mkdir(self,command):
		if len(command) == 2:
			res = self.ftpclient.createRemote_dir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : mkdir <dir_name>"

	#Remove dir
	def rmdir(self,command):
		if len(command) == 2:
			res = self.ftpclient.removeRemote_dir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : rmdir <dir_name>"

	#Remove file
	def rm(self,command):
		if len(command) == 2:
			res = self.ftpclient.removeRemoteFile(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : rm <file_name>"

	#Change mode
	def chmod(self,command):
		if len(command) == 3:
			res = self.ftpclient.changeModeRemoteFile(command[2],command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : chmod <mode> <file_name>"

	#Get Directroy
	def getdir(self,command):
		if len(command) == 2:
			if string.find(command[1],"/") >= 0:
				print string.find(command[1],"/")
				print "sorry <dir_name>/<subdir_name>.. not support"
			else:
				res = self.ftpclient.getRemoteDir(command[1])
				if res <> C_OK:
					self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : getdir <dir_name>"
	
	#Print local current dir
	def lpwd(self):
		res = self.ftpclient.getCurrentLocalDir()
		if res == C_OK:
			self.printMassege(self.ftpclient.getMsg_Obj())
		else:
			self.printError("Connection Error:",self.ftpclient.getError_Obj())

	#Change local dir
	def lcd(self,command):
		if len(command) == 2:
			res = self.ftpclient.changeLocalDir(command[1])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : lcd <dir_name>"

	#Rename Remote File
	def rename(self,command):
		if len(command) == 3:
			res = self.ftpclient.renameRemoteFile(command[1],command[2])
			if res <> C_OK:
				self.printError("Connection Error:",self.ftpclient.getError_Obj())
		else:
			print "usage : rename <from_filename> <to_filename>"

	#Output Help
	def help(self):
		self.printHelp()

	#Output prompt and Input command
	def prompt(self):
		command = self.user_input()
		command = string.split(command," ")
		res = self.method_call(command)
		return res

	def method_call(self,command):
	
		if command[0] == "bye":
			self.bye()
			return C_NG
		elif command[0] == "open":
			self.open(command)
		elif command[0] == "ls":
			self.ls(command)
		elif command[0] == "pwd":
			self.pwd()
		elif command[0] == "cd":
			self.cd(command)
		elif command[0] == "get":
			self.get(command)
		elif command[0] == "put":
			self.put(command)
		elif command[0] == "mkdir":
			self.mkdir(command)
		elif command[0] == "rmdir":
			self.rmdir(command)
		elif command[0] == "rm":
			self.rm(command)
		elif command[0] == "chmod":
			self.chmod(command)
		elif command[0] == "getdir":
			self.getdir(command)
		elif command[0] == "lpwd":
			self.lpwd()
		elif command[0] == "lcd":
			self.lcd(command)
		elif command[0] == "rename":
			self.rename(command)
		elif command[0] == "help":
			self.help()
		else:
			print "?Invalid command"
		return C_OK
		
	#Main Loop
	def main(self):
		while self.prompt():
			pass

	#Initial
	def __init__(self,pacv):
		self.ftpclient = ftpclient.ftpclient()
		self.connectFlag = C_OFF
		if pacv == C_OK:
			self.ftpclient.setPasvmode()

###############################################
#	GUI mode class
###############################################
class ftpgui(Frame):

	#Print Message
	def printMessage(self,color,msg):
	
		self.textMessage.tag_config("red",foreground="red")
		self.textMessage.tag_config("black",foreground="black")
		self.textMessage.tag_config("blue",foreground="blue")
		self.textMessage.insert(END,msg,color)
		#Scroll message box
		self.scrollMessage()
	
	#Print error massege
	def printError(self,err_obj):
		for e in err_obj:
			self.printMessage(C_RED,e)
		self.printMessage(C_BLACK,"\n")
	#Scroll message box to bottom
	def scrollMessage(self):
		self.textMessage.yview(MOVETO,1)

	#Check hostname
	def checkHostname(self,hostname):
		try:
			socket.gethostbyname(hostname)
			return C_OK
		except Exception, e:
			return C_NG
	
	#Connecting to FTP server
	def connect(self):
		if self.connectFlag == C_ON:
			self.printMessage(C_RED,"Already connected , use close first\n")
			return C_NG
		#Get connecting parameters
		hostname = self.HostVar.get()
		portno = self.PortVar.get()
		user = self.UserVar.get()
		password = self.PassVar.get()
		#Check connection parameters
		if hostname == "":
			self.printMessage(C_RED,"Please input hostname\n")
			return C_NG
		if portno == "":
			self.printMessage(C_RED,"Please input portno\n")
			return C_NG
		#Set connection parameters
		self.ftpclient.setHostname(hostname)
		self.ftpclient.setPortno(portno)
		#Check hostname
		self.printMessage(C_BLACK,"Check Hostname(" + hostname + ")..")
		res = self.checkHostname(hostname)
		if res <> C_OK:
			self.printMessage(C_RED,hostname + " is not found\n")
			return C_NG
		self.printMessage(C_BLUE,"OK\n")
		#Connecting FTP server start
		self.printMessage(C_BLACK,"Connect(" + hostname + ":" + portno + ")..")
		res = self.ftpclient.connect()
		if res == C_OK:
			self.printMessage(C_BLUE,"OK\n")
			self.connectFlag = C_ON
			#Set connection parameters
			self.ftpclient.setUser(user)
			self.ftpclient.setPassword(password)
			#Login to FTP server
			if user == "":
				user = "anonymous"
			self.printMessage(C_BLACK,"Login(" + user + ")..")
			res = self.ftpclient.login()
			if res == C_OK:
				self.getRemoteDirList()
				self.printMessage(C_BLUE,"OK\n")
			else:
				self.printMessage(C_RED,"Failure\n")
		else:
			self.printMessage(C_RED,"Failure\n")
	#Disconnect to FTP server
	def disconnect(self):
		if self.connectFlag == C_ON:
			self.printMessage(C_BLACK,"Disconnect..")
			res = self.ftpclient.close()
			if res <> C_OK:
				self.printMessage(C_RED,"Failure\n")
				return C_NG
			#clear to remote widget
			self.listRemote.delete(0,END)
			self.RemotePathVar.set("")
			self.connectFlag = C_OFF
			self.printMessage(C_BLUE,"OK\n")

	#FTPy quit
	def quit(self):
		self.disconnect()
		self.master.destroy()

	#Output version infomation
	def showVersion(self):
		tkMessageBox.showinfo(title="Version",message="FTPy\nVersion 0.1.1\nCreater:shinkichi")
	
	#File update(Local -> Remote)
	def update(self):
		#Get select file
		indexes = self.listLocal.curselection()
		if len(indexes) == 0:
			return C_NG
		for e in indexes:
			item = self.listLocal.get(e)
			#Check item
			if item[0] == "-":	#File
				filename = item[string.rfind(item," ")+1:]
				self.printMessage(C_BLACK,"Update(" + filename + ")..")
				#Call putLocalFile method
				res = self.ftpclient.putLocalFile(filename,filename)
				if res == C_OK:
					self.printMessage(C_BLUE,"OK\n")
					self.getRemoteDirList()
				else:
					self.printMessage(C_RED,"Failure\n")
	
	#File download(Remote -> Local)
	def download(self):
		#Get select file
		indexes = self.listRemote.curselection()
		if len(indexes) == 0:
			return C_NG
		for e in indexes:
			item = self.listRemote.get(e)
			#Check item
			if item[0] == "-":	#File
				filename = item[string.rfind(item," ")+1:]
				self.printMessage(C_BLACK,"Download(" + filename + ")..")
				#Call getRemoteFile method
				res = self.ftpclient.getRemoteFile(filename,filename)
				if res == C_OK:
					self.printMessage(C_BLUE,"OK\n")
					self.getLocalDirList()
				else:
					self.printMessage(C_RED,"Failure\n")
			elif item[0] == "d":	#Directory
				dirname = item[string.rfind(item," ")+1:]
				self.printMessage(C_BLACK,"Download(" + dirname + ")..")
				#Call getRemoteDir method
				res = self.ftpclient.getRemoteDir(dirname)
				if res == C_OK:
					self.printMessage(C_BLUE,"OK\n")
					self.getLocalDirList()
				else:
					self.printMessage(C_RED,"Failure\n")

	#Refresh dirctory list(Local,Remote)
	def refresh(self):
		self.getLocalDirList()
		self.getRemoteDirList()

	#Refresh local directory list
	def getLocalDirList(self):
		#Call getCurrentLocalDir method
		res = self.ftpclient.getCurrentLocalDir()
		if res <> C_OK:
			self.printMessage(C_BLACK,"Connection..Failure\n")
			return C_NG
		#Get local current directory
		current_dir = self.ftpclient.getMsg_Obj()
		self.LocalPathVar.set(current_dir[0])
		#Clear local directory list
		self.listLocal.delete(0,END)
		#Call getLocalDirData method
		res = self.ftpclient.getLocalDirData(current_dir[0])
		if res <> C_OK:
			self.printMessage(C_RED,"Connection..Failure\n")
			return C_NG
		#Get local directory data
		dir_obj = []
		dir_obj = self.ftpclient.getLocalDir_Obj()
		dir_obj.sort()
		#Insert local directory entry
		self.listLocal.insert(END,"d ..")
		for e in dir_obj:
			filesize = str(os.path.getsize(e))
			filesize = " " * (11 - len(filesize)) + str(filesize)
			if e[0] <> ".":
				if os.path.isfile(e):
					item = "- " + filesize + " " + e
				elif os.path.isdir(e):
					item = "d " + filesize + " " + e
				elif os.path.islink(e):
					item = "l " + filesize + " " + e
				else:
					item = "? " + filesize + " " + e
				self.listLocal.insert(END,item)
	
	#Refresh remote directory list
	def getRemoteDirList(self):
		#Get remote current directory
		res = self.ftpclient.getCurrentRemoteDir()
		if res <> C_OK:
			self.printMessage(C_RED,"Connection..Failure\n")
			return C_NG
		current_dir = self.ftpclient.getMsg_Obj()
		self.RemotePathVar.set(current_dir[0])
		#Clear remote directory list
		self.listRemote.delete(0,END)
		#Get remote directory data 
		res = self.ftpclient.getRemoteDirData()
		if res <> C_OK:
			self.printMessage(C_RED,"Connection..Failure\n")
			return C_NG
		dir_obj = []
		dir_obj = self.ftpclient.getRemoteDir_Obj()
		#Insert remote directory entry
		if current_dir[0] <> "/":
			self.listRemote.insert(END,"d ..")
		for e in dir_obj:
			if e[0] == "d" or e[0] == "-" or e[0] == "l":
				line_ent = []
				line_ent = self.splitDirEntry(e)
				permission = line_ent[0] 
				filesize = line_ent[4]
				filename = line_ent[len(line_ent)-1]
				if len(filesize) < 10:
					add_space = " " * (11 - len(filesize))
					filesize = add_space + filesize
				item = permission + filesize + " " + filename 
				self.listRemote.insert(END,item)

	#Split directory entry
	def splitDirEntry(self,entry):
		line_ent = []
		for e in string.split(entry," "):
			if e <> "":
				line_ent.append(e)
		return line_ent

	#Change mode(Remote)
	def changeMode(self):
		indexed = self.listRemote.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listRemote.get(indexed[0])
		#Check item
		if item[0] == "-" or item[0] == "d":	#File,Dirctory
			objname = item[string.rfind(item," ")+1:]
		mode = tkSimpleDialog.askstring("Change Mode","Mode\nexampl:744 +x")
		if mode <> None:
			self.printMessage(C_BLACK,"chmod(" + mode + ")..")
			res = self.ftpclient.changeModeRemoteFile(objname,mode)
			if res == C_OK:
				self.printMessage(C_BLUE,"OK\n")
				self.getRemoteDirList()
			else:
				self.printError(self.ftpclient.getError_Obj())
				return C_NG

	#Create directory(Remote)
	def createDirectory(self):
		dirname = tkSimpleDialog.askstring("Create Directory","Directory Name")
		if dirname <> None:
			self.printMessage(C_BLACK,"mkdir(" + dirname + ")..")
			res = self.ftpclient.createRemote_dir(dirname)
			if res == C_OK:
				self.printMessage(C_BLUE,"OK\n")
				self.getRemoteDirList()
			else:
				self.printError(self.ftpclient.getError_Obj())
				return C_NG
				

	#Remote directory list(Event)
	def doubleClickRemote(self,event):
		#Get select item
		indexed = self.listRemote.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listRemote.get(indexed[0])
		#Check item
		if item[0] == "d":	#Directory
			dirname = item[string.rfind(item," ")+1:]
			self.printMessage(C_BLACK,"cd(" + dirname + ")..")
			#Change remote directory
			res = self.ftpclient.changeRemoteDir(dirname)
			if res <> C_OK:
				self.printMessage(C_RED,"Connection..Failure\n")
				return C_NG
			self.printMessage(C_BLUE,"OK\n")
			self.getRemoteDirList()

	#Local directory list(Event)
	def doubleClickLocal(self,event):
		#Get select item
		indexed = self.listLocal.curselection()
		if len(indexed) == 0:
			return C_NG
		item = self.listLocal.get(indexed[0])
		#Check item
		if item[0] == "d":	#Directory
			dirname = item[string.rfind(item," ")+1:]
			#Change local directory
			res = self.ftpclient.changeLocalDir(dirname)
			if res <> C_OK:
				self.printMessage(C_RED,"Connection..Failure\n")
				return C_NG
			self.getLocalDirList()

	#Print FTPy widget
	def printGUI(self):
		### Tk ###
		self.master.title("FTPy-0.1.1")
		
		### Frame ###
		frameTop = Frame(self)
		frameToolbar = Frame(self)
		frameLocal = Frame(self)
		frameButton = Frame(self)
		frameRemote = Frame(self)
		frameMessage = Frame(self)
		frameTop.grid(row=0,column=0,columnspan=3)
		frameToolbar.grid(row=1,column=0,columnspan=3,sticky=W)
		frameLocal.grid(row=2,column=0)
		frameButton.grid(row=2,column=1)
		frameRemote.grid(row=2,column=2)
		frameMessage.grid(row=3,column=0,columnspan=3)
		
		### Menu ###
		menuTop = Menu(tearoff=1)
		## Menu connect ##
		menuConnect = Menu(menuTop)
		menuTop.add_cascade(label="connect",menu=menuConnect)
		#Connect
		menuConnect.add_command(label="connect",command=self.connect)			
		#Disconnect
		menuConnect.add_command(label="disconnect",command=self.disconnect)
		#Close
		menuConnect.add_command(label="quit",command=self.quit)
		## Menu display ##
		menuDisplay = Menu(menuTop)
		menuTop.add_cascade(label="display",menu=menuDisplay)
		#Refresh
		menuDisplay.add_command(label="refresh",command=self.refresh)
		## Menu help ##
		menuHelp = Menu(menuTop)
		menuTop.add_cascade(label="help",menu=menuHelp)
		#Version
		menuHelp.add_command(label="version",command=self.showVersion)
		self.master.config(menu=menuTop)
		## Popup menu(Remote) ##
		self.menuPopupRemote = Menu()
		#Change mode
		self.menuPopupRemote.add_command(label="Change mode",command=self.changeMode)
		#Create directory
		self.menuPopupRemote.add_command(label="Create directory",command=self.createDirectory)

		### Host infomation ###
		#Hostname
		self.HostVar = StringVar()
		self.HostVar.set("")
		labelHost = Label(frameTop,text="Hostname")
		entryHost = Entry(frameTop,width="20",bg="white",textvariable=self.HostVar)
		#Portno
		self.PortVar = StringVar()
		self.PortVar.set("21")
		labelPort = Label(frameTop,text="Port")
		entryPort = Entry(frameTop,width="4",bg="white",textvariable=self.PortVar)
		#User
		self.UserVar = StringVar()
		self.UserVar.set("")
		labelUser = Label(frameTop,text="User")
		entryUser = Entry(frameTop,width="10",bg="white",textvariable=self.UserVar)
		#Password
		self.PassVar = StringVar()
		self.PassVar.set("")
		labelPass = Label(frameTop,text="Password")
		entryPass = Entry(frameTop,width="10",bg="white",textvariable=self.PassVar,show="*")
		entryHost.bind("<Return>",self.pressEnter)
		entryPort.bind("<Return>",self.pressEnter)
		entryUser.bind("<Return>",self.pressEnter)
		entryPass.bind("<Return>",self.pressEnter)
		labelHost.grid(row=0,column=1)
		entryHost.grid(row=0,column=2)
		labelPort.grid(row=0,column=3)
		entryPort.grid(row=0,column=4)
		labelUser.grid(row=0,column=5)
		entryUser.grid(row=0,column=6)
		labelPass.grid(row=0,column=7)
		entryPass.grid(row=0,column=8)

		### Toolbar ###
		#Toolbar connect
		btnConnect = Button(frameToolbar,bitmap="@connect.xbm",width="24",height="24",command=self.connect)
		#Toolbar disconnect
		btnDisconnect = Button(frameToolbar,bitmap="error",width="24",height="24",command=self.disconnect)
		btnConnect.grid(row=0,column=0,sticky=W+E)
		btnDisconnect.grid(row=0,column=1,sticky=W)
		
		### Local dir list ###
		#Local Path
		self.LocalPathVar = StringVar()
		self.LocalPathVar.set("")
		entryLocalPath = Entry(frameLocal,width="34",textvariable=self.LocalPathVar)
		entryLocalPath.grid(row=0,column=0)
		#List
		self.listLocal = Listbox(frameLocal,selectmode=EXTENDED,width=40,height=10,bg="white",font="system")
		scrvLocal = Scrollbar(frameLocal,orient=VERTICAL,command=self.listLocal.yview)
		scrhLocal = Scrollbar(frameLocal,orient=HORIZONTAL,command=self.listLocal.xview)
		self.listLocal.config(xscrollcommand=scrhLocal.set,yscrollcommand=scrvLocal.set)
		self.listLocal.bind("<Double-Button-1>",self.doubleClickLocal)
		self.listLocal.grid(row=1,column=0)
		scrvLocal.grid(row=1,column=1,sticky=NS)
		scrhLocal.grid(row=2,column=0,sticky=EW)

		### Button(Update,Download) ###
		#Button update & download
		btnUpdate = Button(frameButton,text="->",command=self.update)
		btnDownload = Button(frameButton,text="<-",command=self.download)
		btnUpdate.grid(row=0,column=0)
		btnDownload.grid(row=1,column=0)
		
		### Remote dir list ###
		#Remote Path
		self.RemotePathVar = StringVar()
		self.RemotePathVar.set("")
		entryRemotePath = Entry(frameRemote,width="34",textvariable=self.RemotePathVar)
		entryRemotePath.grid(row=0,column=0)
		#List
		self.listRemote = Listbox(frameRemote,selectmode=EXTENDED,width=40,height=10,bg="white",font="system")
		scrvRemote = Scrollbar(frameRemote,orient=VERTICAL,command=self.listRemote.yview)
		scrhRemote = Scrollbar(frameRemote,orient=HORIZONTAL,command=self.listRemote.xview)
		self.listRemote.config(xscrollcommand=scrhRemote.set,yscrollcommand=scrvRemote.set)
		self.listRemote.bind("<Double-Button-1>",self.doubleClickRemote)
		self.listRemote.bind("<ButtonRelease-3>",self.button3ClickRemote)
		self.listRemote.grid(row=1,column=0)
		scrvRemote.grid(row=1,column=1,sticky=NS)
		scrhRemote.grid(row=2,column=0,sticky=EW)

		### Message ###
		self.textMessage = Text(frameMessage,width=78,height=6)
		scrvMessage = Scrollbar(frameMessage,orient=VERTICAL,command=self.textMessage.yview)
		self.textMessage.config(yscrollcommand=scrvMessage.set)
		self.textMessage.grid(row=0,column=0)
		scrvMessage.grid(row=0,column=1,sticky=NS)

	#Entry press <Enter key>
	def pressEnter(self,event):
		self.connect()

	#Button3 Click(Remote)
	def button3ClickRemote(self,event):
		self.menuPopupRemote.tk_popup(event.x_root,event.y_root)

	#Class initial
	def __init__(self,hostname="",portno=21,pasv=C_OFF):
		master=None
		Frame.__init__(self,master)
		self.pack()
		self.printGUI()
		self.HostVar.set(hostname)
		self.PortVar.set(portno)
		self.ftpclient = ftpclient.ftpclient()
		self.getLocalDirList()
		self.connectFlag = C_OFF
		if pasv == C_ON:
			self.ftpclient.setPasvmode()

	
	
